/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Arrays;
import java.util.HashMap;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.Solution;
import net.fortytwo.stream.caching.SolutionGroup;
import net.fortytwo.stream.caching.SolutionPattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SolutionGroupTest {
    private long now;
    private Bindings<String> bindings;

    @Before
    public void setUp() throws Exception {
        this.now = System.currentTimeMillis();
        Query.QueryVariables vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        bindingMap.put("x", "red");
        bindingMap.put("y", "green");
        bindingMap.put("z", "blue");
        this.bindings = new Bindings(bindingMap, vars);
    }

    @Test
    public void testAll() throws Exception {
        long exp = 0L;
        Solution ps = new Solution(3, 0, this.bindings, exp);
        SolutionGroup g = new SolutionGroup(this.bindings);
        Assert.assertEquals((long)0L, (long)g.getSolutions().length());
        g.add(ps, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)2L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        g.add(ps, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        ps = new Solution(ps, 1);
        g.add(ps, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)1L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        ps = new Solution(3, 2, this.bindings, exp);
        g.add(ps, this.now);
        Assert.assertEquals((long)2L, (long)g.getSolutions().length());
        Assert.assertEquals((long)2L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)4L, (long)((SolutionPattern)g.getSolutions().getValue()).matchedPatterns);
        ps = new Solution(ps, 1);
        g.add(ps, this.now);
        Assert.assertEquals((long)2L, (long)g.getSolutions().length());
        Assert.assertEquals((long)1L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)6L, (long)((SolutionPattern)g.getSolutions().getValue()).matchedPatterns);
        ps = new Solution(ps, 0);
        g.add(ps, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)0L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)7L, (long)((SolutionPattern)g.getSolutions().getValue()).matchedPatterns);
    }

    @Test(expected=IllegalStateException.class)
    public void testCantAddExpired() throws Exception {
        Solution solExp1 = new Solution(3, 0, this.bindings, 42L);
        SolutionGroup g = new SolutionGroup(this.bindings);
        g.add(solExp1, this.now);
    }

    @Test
    public void testRemoveExpired() throws Exception {
        this.now = 42L;
        Solution solExp1 = new Solution(5, 0, this.bindings, this.now + 10000L);
        Solution solExp2 = new Solution(new Solution(5, 1, this.bindings, this.now + 5000L), 2);
        Solution solNonExp1 = new Solution(new Solution(5, 4, this.bindings, 0L), 1);
        Solution solNonExp2 = new Solution(new Solution(5, 3, this.bindings, 0L), 1);
        Solution solExp3 = new Solution(5, new Solution(5, 3, this.bindings, 0L), new Solution(5, 4, this.bindings, this.now + 20000L));
        SolutionGroup g = new SolutionGroup(this.bindings);
        g.add(solExp1, this.now);
        g.add(solExp2, this.now);
        g.add(solNonExp1, this.now);
        g.add(solNonExp2, this.now);
        g.add(solExp3, this.now);
        Assert.assertEquals((long)5L, (long)g.getSolutions().length());
        g.removeExpired(this.now);
        Assert.assertEquals((long)5L, (long)g.getSolutions().length());
        this.now += 6000L;
        g.removeExpired(this.now);
        Assert.assertEquals((long)4L, (long)g.getSolutions().length());
        this.now += 5000L;
        g.removeExpired(this.now);
        Assert.assertEquals((long)3L, (long)g.getSolutions().length());
        this.now += 10000L;
        g.removeExpired(this.now);
        Assert.assertEquals((long)2L, (long)g.getSolutions().length());
    }

    @Test
    public void testExpirationLogicOnInsertion() throws Exception {
        SolutionGroup g = new SolutionGroup(this.bindings);
        this.now = 42L;
        Solution sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 10000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 10000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 5000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 20000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 20000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, 0L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)0L, (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(5, 0, this.bindings, 0L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)0L, (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(5, 0, this.bindings, this.now + 10000L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)0L, (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        g = new SolutionGroup(this.bindings);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 10000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(5, 0, this.bindings, this.now + 20000L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)2L, (long)g.getSolutions().length());
        Assert.assertEquals((long)4L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 20000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        g = new SolutionGroup(this.bindings);
        sol1 = new Solution(5, 0, this.bindings, this.now + 10000L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)4L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 10000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        g = new SolutionGroup(this.bindings);
        sol1 = new Solution(5, 0, this.bindings, this.now + 10000L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)4L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 20000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 20000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        g = new SolutionGroup(this.bindings);
        sol1 = new Solution(5, 0, this.bindings, this.now + 10000L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)4L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, 0L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)0L, (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        g = new SolutionGroup(this.bindings);
        sol1 = new Solution(5, 0, this.bindings, this.now + 10000L);
        g.add(sol1, this.now);
        Assert.assertEquals((long)1L, (long)g.getSolutions().length());
        Assert.assertEquals((long)4L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 10000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
        sol1 = new Solution(new Solution(5, 0, this.bindings, this.now + 5000L), 1);
        g.add(sol1, this.now);
        Assert.assertEquals((long)2L, (long)g.getSolutions().length());
        Assert.assertEquals((long)3L, (long)((SolutionPattern)g.getSolutions().getValue()).remainingPatterns);
        Assert.assertEquals((long)(this.now + 5000L), (long)((SolutionPattern)g.getSolutions().getValue()).expirationTime);
    }
}

