/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.QueryIndex;
import net.fortytwo.stream.model.VariableOrConstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryIndexTest {
    private static final int QUERY_TTL = 0;
    private long now;
    private Query.QueryVariables vars;
    private QueryIndex<String, String> queryIndex;

    @Before
    public void setUp() {
        this.now = System.currentTimeMillis();
        this.vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        int tupleSize = 3;
        this.queryIndex = new QueryIndex(tupleSize);
    }

    @Test
    public void testSimpleJoin() throws Exception {
        VariableOrConstant[] pattern1 = new VariableOrConstant[]{this.newTerm(null, "x"), this.newTerm("isRedderThan", null), this.newTerm(null, "z")};
        VariableOrConstant[] pattern2 = new VariableOrConstant[]{this.newTerm(null, "x"), this.newTerm("htmlValue", null), this.newTerm("ff0000", null)};
        LinkedList<VariableOrConstant[]> patterns = new LinkedList<VariableOrConstant[]>();
        patterns.add(pattern1);
        patterns.add(pattern2);
        Query query = new Query(patterns, 0L);
        this.queryIndex.add(query);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] tuple = new String[]{"puce", "isRedderThan", "khaki"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"kazoo", "isKindOf", "instrument"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"red", "isRedderThan", "blue"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"red", "htmlValue", "ff0000"};
        map.clear();
        map.put("x", "red");
        map.put("z", "blue");
        this.assertSolutions(this.now, this.vars, tuple, map);
    }

    @Test
    public void testLength2Cycle() throws Exception {
        VariableOrConstant[] pattern1 = new VariableOrConstant[]{this.newTerm(null, "x"), this.newTerm("knows", null), this.newTerm(null, "y")};
        VariableOrConstant[] pattern2 = new VariableOrConstant[]{this.newTerm(null, "y"), this.newTerm("knows", null), this.newTerm(null, "x")};
        LinkedList<VariableOrConstant[]> patterns = new LinkedList<VariableOrConstant[]>();
        patterns.add(pattern1);
        patterns.add(pattern2);
        Query query = new Query(patterns, 0L);
        this.queryIndex.add(query);
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        String[] tuple = new String[]{"arthur", "knows", "ford"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"ford", "knows", "arthur"};
        map1.clear();
        map1.put("x", "arthur");
        map1.put("y", "ford");
        map2.clear();
        map2.put("y", "arthur");
        map2.put("x", "ford");
        this.assertSolutions(this.now, this.vars, tuple, map1, map2);
    }

    @Test
    public void testLength3Cycle() throws Exception {
        VariableOrConstant[] pattern1 = new VariableOrConstant[]{this.newTerm(null, "x"), this.newTerm("knows", null), this.newTerm(null, "y")};
        VariableOrConstant[] pattern2 = new VariableOrConstant[]{this.newTerm(null, "y"), this.newTerm("knows", null), this.newTerm(null, "z")};
        VariableOrConstant[] pattern3 = new VariableOrConstant[]{this.newTerm(null, "z"), this.newTerm("knows", null), this.newTerm(null, "x")};
        LinkedList<VariableOrConstant[]> patterns = new LinkedList<VariableOrConstant[]>();
        patterns.add(pattern1);
        patterns.add(pattern2);
        patterns.add(pattern3);
        Query query = new Query(patterns, 0L);
        this.queryIndex.add(query);
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        HashMap<String, String> map3 = new HashMap<String, String>();
        String[] tuple = new String[]{"arthur", "knows", "ford"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"ford", "knows", "zaphod"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"ford", "knows", "arthur"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"zaphod", "knows", "trillian"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"trillian", "knows", "marvin"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"zaphod", "mocks", "arthur"};
        this.assertSolutions(this.now, this.vars, tuple, new Map[0]);
        tuple = new String[]{"marvin", "knows", "marvin"};
        map1.clear();
        map1.put("x", "marvin");
        map1.put("y", "marvin");
        map1.put("z", "marvin");
        this.assertSolutions(this.now, this.vars, tuple, map1);
        tuple = new String[]{"zaphod", "knows", "arthur"};
        map1.clear();
        map1.put("x", "arthur");
        map1.put("y", "ford");
        map1.put("z", "zaphod");
        map2.clear();
        map2.put("x", "ford");
        map2.put("y", "zaphod");
        map2.put("z", "arthur");
        map3.clear();
        map3.put("x", "zaphod");
        map3.put("y", "arthur");
        map3.put("z", "ford");
        this.assertSolutions(this.now, this.vars, tuple, map1, map2, map3);
    }

    @Test
    public void testRemoveExpired() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        long now = 42L;
        VariableOrConstant[] pattern1 = new VariableOrConstant[]{this.newTerm(null, "x"), this.newTerm("knows", null), this.newTerm(null, "y")};
        VariableOrConstant[] pattern2 = new VariableOrConstant[]{this.newTerm(null, "y"), this.newTerm("knows", null), this.newTerm(null, "z")};
        VariableOrConstant[] pattern3 = new VariableOrConstant[]{this.newTerm(null, "z"), this.newTerm("knows", null), this.newTerm(null, "a")};
        LinkedList<VariableOrConstant[]> patterns = new LinkedList<VariableOrConstant[]>();
        patterns.add(pattern1);
        patterns.add(pattern2);
        patterns.add(pattern3);
        Query query1 = new Query(patterns, 0L);
        this.queryIndex.add(query1);
        pattern1 = new VariableOrConstant[]{this.newTerm(null, "a"), this.newTerm("name", null), this.newTerm("\"Arthur Dent\"", null)};
        pattern2 = new VariableOrConstant[]{this.newTerm(null, "a"), this.newTerm("race", null), this.newTerm("human", null)};
        patterns = new LinkedList();
        patterns.add(pattern1);
        patterns.add(pattern2);
        Query query2 = new Query(patterns, now + 60000L);
        this.queryIndex.add(query2);
        pattern1 = new VariableOrConstant[]{this.newTerm("Paris", null), this.newTerm("capitalCityOf", null), this.newTerm(null, "country")};
        pattern2 = new VariableOrConstant[]{this.newTerm(null, "country"), this.newTerm("name", null), this.newTerm(null, "name")};
        pattern3 = new VariableOrConstant[]{this.newTerm(null, "country"), this.newTerm("population", null), this.newTerm(null, "pop")};
        patterns = new LinkedList();
        patterns.add(pattern1);
        patterns.add(pattern2);
        patterns.add(pattern3);
        Query query3 = new Query(patterns, now + 120000L);
        this.queryIndex.add(query3);
        this.queryIndex.removeExpired(now);
        String[] tuple = new String[]{"arthur", "knows", "ford"};
        this.assertSolutions(now, query1.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"ford", "knows", "zaphod"};
        this.assertSolutions(now, query1.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"zaphod", "knows", "trillian"};
        map.clear();
        map.put("x", "arthur");
        map.put("y", "ford");
        map.put("z", "zaphod");
        map.put("a", "trillian");
        this.assertSolutions(now, query1.getVariables(), tuple, map);
        tuple = new String[]{"arthur", "name", "\"Arthur Dent\""};
        this.assertSolutions(now, query2.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"arthur", "race", "human"};
        map.clear();
        map.put("a", "arthur");
        this.assertSolutions(now, query2.getVariables(), tuple, map);
        tuple = new String[]{"Paris", "capitalCityOf", "France"};
        this.assertSolutions(now, query3.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"France", "name", "\"France\""};
        this.assertSolutions(now, query3.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"France", "population", "dozens of millions"};
        map.clear();
        map.put("country", "France");
        map.put("name", "\"France\"");
        map.put("pop", "dozens of millions");
        this.assertSolutions(now, query3.getVariables(), tuple, map);
        this.queryIndex.removeExpired(now += 61000L);
        tuple = new String[]{"zaphod", "knows", "marvin"};
        map.clear();
        map.put("x", "arthur");
        map.put("y", "ford");
        map.put("z", "zaphod");
        map.put("a", "marvin");
        this.assertSolutions(now, query1.getVariables(), tuple, map);
        tuple = new String[]{"arthur", "name", "\"Arthur\""};
        this.assertSolutions(now, query2.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"arthur", "race", "ape-descendant"};
        this.assertSolutions(now, query2.getVariables(), tuple, new Map[0]);
        tuple = new String[]{"France", "population", "tens of millions"};
        map.clear();
        map.put("country", "France");
        map.put("name", "\"France\"");
        map.put("pop", "tens of millions");
        this.assertSolutions(now, query3.getVariables(), tuple, map);
        this.queryIndex.removeExpired(now += 61000L);
        tuple = new String[]{"zaphod", "knows", "eddie"};
        map.clear();
        map.put("x", "arthur");
        map.put("y", "ford");
        map.put("z", "zaphod");
        map.put("a", "eddie");
        this.assertSolutions(now, query1.getVariables(), tuple, map);
        tuple = new String[]{"France", "population", "zillions of millions"};
        this.assertSolutions(now, query3.getVariables(), tuple, new Map[0]);
    }

    private <T> void assertSolutions(long now, Query.QueryVariables vars, T[] tuple, Map<String, T> ... expected) {
        int ttl = 0;
        HashMap<Integer, Bindings> all = new HashMap<Integer, Bindings>();
        HashMap<Integer, Integer> expectedCount = new HashMap<Integer, Integer>();
        for (Map<String, T> m : expected) {
            Bindings bindings2 = new Bindings(m, vars);
            int hash = bindings2.getHash();
            all.put(hash, bindings2);
            Integer c = (Integer)expectedCount.get(hash);
            if (null == c) {
                c = 0;
            }
            expectedCount.put(hash, c + 1);
        }
        HashMap actualCount = new HashMap();
        BiConsumer<String, Bindings> handler = (id, bindings) -> {
            int hash = bindings.getHash();
            all.put(hash, (Bindings)bindings);
            Integer c = (Integer)actualCount.get(hash);
            if (null == c) {
                c = 0;
            }
            actualCount.put(hash, c + 1);
        };
        QueryIndex<String, String> index = this.queryIndex;
        index.add((Object[])tuple, handler, ttl, now);
        for (Map.Entry e : all.entrySet()) {
            int cmp;
            Integer act = (Integer)actualCount.get(e.getKey());
            Integer exp = (Integer)expectedCount.get(e.getKey());
            if (null == act) {
                act = 0;
            }
            if (null == exp) {
                exp = 0;
            }
            if ((cmp = exp.compareTo(act)) < 0) {
                Assert.fail((String)("unexpected solution: " + e.getValue()));
                continue;
            }
            if (cmp <= 0) continue;
            Assert.fail((String)("expected solution not produced: " + e.getValue()));
        }
    }

    private VariableOrConstant<String, String> newTerm(String constant, String variable) {
        return new VariableOrConstant((Object)variable, (Object)constant);
    }
}

