/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import org.junit.Assert;
import org.junit.Test;

public class BindingsTest {
    @Test
    public void testHash() throws Exception {
        Query.QueryVariables vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<Integer> hashes = new HashSet<Integer>();
        map.clear();
        map.put("x", "red");
        int hash = new Bindings(map, vars).getHash();
        hashes.add(hash);
        map.clear();
        map.put("x", "red");
        map.put("y", "green");
        hash = new Bindings(map, vars).getHash();
        hashes.add(hash);
        map.clear();
        map.put("x", "green");
        map.put("y", "red");
        hash = new Bindings(map, vars).getHash();
        hashes.add(hash);
        map.clear();
        map.put("x", "blue");
        hash = new Bindings(map, vars).getHash();
        hashes.add(hash);
        Assert.assertEquals((long)4L, (long)hashes.size());
    }

    @Test
    public void testCompatibility() throws Exception {
        Query.QueryVariables vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        Bindings b1 = new Bindings(map1, vars);
        Assert.assertEquals((Object)"red", (Object)b1.get("x"));
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("y", "green");
        Bindings b2 = new Bindings(map2, vars);
        Assert.assertNull((Object)b2.get("x"));
        Assert.assertEquals((Object)"green", (Object)b2.get("y"));
        Assert.assertTrue((boolean)b1.compatibleWith(b2, vars));
        Assert.assertTrue((boolean)b2.compatibleWith(b1, vars));
        Bindings b3 = Bindings.from((Bindings)b1, (Bindings)b2);
        Assert.assertEquals((Object)"red", (Object)b3.get("x"));
        Assert.assertEquals((Object)"green", (Object)b3.get("y"));
        Assert.assertTrue((boolean)b1.compatibleWith(b3, vars));
        Assert.assertTrue((boolean)b2.compatibleWith(b3, vars));
        Assert.assertTrue((boolean)b3.compatibleWith(b2, vars));
        Assert.assertTrue((boolean)b3.compatibleWith(b1, vars));
        map1 = new HashMap();
        map1.put("x", "puce");
        b1 = new Bindings(map1, vars);
        Assert.assertEquals((Object)"puce", (Object)b1.get("x"));
        Assert.assertFalse((boolean)b1.compatibleWith(b3, vars));
        Assert.assertFalse((boolean)b3.compatibleWith(b1, vars));
        Assert.assertTrue((boolean)b1.compatibleWith(b2, vars));
        Assert.assertTrue((boolean)b2.compatibleWith(b1, vars));
    }

    @Test
    public void testBindingsFromComponents() throws Exception {
        Query.QueryVariables vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        HashMap<String, String> map1a = new HashMap<String, String>();
        map1a.put("x", "red");
        map1a.put("y", "green");
        HashMap<String, String> map1b = new HashMap<String, String>();
        map1b.put("x", "red");
        map1b.put("y", "green");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("x", "red");
        map2.put("y", "green");
        map2.put("z", "blue");
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("x", "red");
        map3.put("z", "blue");
        Bindings b1a = new Bindings(map1a, vars);
        Bindings b1b = new Bindings(map1b, vars);
        Bindings b2 = new Bindings(map2, vars);
        Bindings b3 = new Bindings(map3, vars);
        Bindings result = Bindings.from((Bindings)b1a, (Bindings)b1b);
        Assert.assertTrue((result == b1a ? 1 : 0) != 0);
        Assert.assertFalse((result == b1b ? 1 : 0) != 0);
        result = Bindings.from((Bindings)b1a, (Bindings)b2);
        Assert.assertTrue((result == b2 ? 1 : 0) != 0);
        result = Bindings.from((Bindings)b2, (Bindings)b1a);
        Assert.assertTrue((result == b2 ? 1 : 0) != 0);
        result = Bindings.from((Bindings)b1a, (Bindings)b3);
        Assert.assertFalse((result == b1a ? 1 : 0) != 0);
        Assert.assertFalse((result == b3 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"red", (Object)result.get("x"));
        Assert.assertEquals((Object)"green", (Object)result.get("y"));
        Assert.assertEquals((Object)"blue", (Object)result.get("z"));
        result = Bindings.from((Bindings)b2, (Bindings)result);
        Assert.assertTrue((result == b2 ? 1 : 0) != 0);
    }
}

