/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.stream.shj.Expirable;
import net.fortytwo.stream.shj.Index;

public class Solution<V>
implements Expirable {
    private static final Logger logger = Logger.getLogger(Solution.class.getName());
    private V[] values;
    private Integer hashCode;
    private final Index<Solution<V>> expirationIndex;
    private final long expirationTime;

    public Solution(V[] values, long expirationTime, Index<Solution<V>> expirationIndex) {
        this.values = values;
        this.expirationTime = expirationTime;
        this.expirationIndex = expirationIndex;
    }

    public Solution(V[] values, Index<Solution<V>> expirationIndex) {
        this(values, Long.MAX_VALUE, expirationIndex);
    }

    public V[] getValues() {
        return this.values;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void expire() {
        this.expirationIndex.remove(this);
        this.values = null;
        this.hashCode = null;
    }

    @Override
    public boolean isExpired() {
        return null == this.values;
    }

    public int compareByExpirationTime(Solution<V> other) {
        return this.expirationTime == Long.MAX_VALUE ? (other.expirationTime == Long.MAX_VALUE ? 0 : 1) : (other.expirationTime == Long.MAX_VALUE ? -1 : Long.valueOf(this.expirationTime).compareTo(other.expirationTime));
    }

    public int hashCode() {
        if (null == this.hashCode) {
            this.hashCode = Arrays.hashCode(this.values);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Solution && Solution.equals(this, (Solution)other);
    }

    private static <V> boolean equals(Solution<V> s1, Solution<V> s2) {
        if (s1.hashCode() != s2.hashCode() || s1.values.length != s2.values.length) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("solution equality or hash collision. Performing (expensive) element-wise comparison");
        }
        for (int i = 0; i < s1.values.length; ++i) {
            if (s2.values[i].equals(s1.values[i])) continue;
            return false;
        }
        return true;
    }
}

