/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.fortytwo.stream.model.VariableOrConstant;
import net.fortytwo.stream.shj.GraphPattern;
import net.fortytwo.stream.shj.Index;
import net.fortytwo.stream.shj.JoinHelper;
import net.fortytwo.stream.shj.Query;
import net.fortytwo.stream.shj.QueryContext;
import net.fortytwo.stream.shj.Solution;
import net.fortytwo.stream.shj.SolutionIndex;
import net.fortytwo.stream.shj.TuplePattern;

public class QueryIndex<K, V>
implements Index<Query<K, V>> {
    private static final Logger logger = Logger.getLogger(QueryIndex.class.getName());
    private final QueryContext<K, V> queryContext;
    private QueryIndex<K, V>[] variableIndices;
    private Map<V, QueryIndex<K, V>> constantIndices;
    private SolutionIndex<V> solutionIndex;
    private final Set<Query<K, V>> queries;

    private QueryIndex() {
        this.queryContext = null;
        this.queries = null;
    }

    public QueryIndex(QueryContext<K, V> queryContext) {
        this.queryContext = queryContext;
        this.queries = new HashSet<Query<K, V>>();
    }

    @Override
    public synchronized void clear() {
        if (null != this.variableIndices) {
            for (int i = 0; i < this.variableIndices.length; ++i) {
                QueryIndex<K, V> index = this.variableIndices[i];
                if (null == index) continue;
                index.clear();
                this.variableIndices[i] = null;
            }
            this.variableIndices = null;
        }
        if (null != this.constantIndices) {
            for (QueryIndex<K, V> index : this.constantIndices.values()) {
                index.clear();
            }
            this.constantIndices.clear();
            this.constantIndices = null;
        }
        if (null != this.solutionIndex) {
            this.solutionIndex.clear();
            this.solutionIndex = null;
        }
        if (null != this.queries) {
            this.queries.clear();
        }
        if (null != this.queryContext) {
            this.queryContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(Query<K, V> query) {
        if (null == query) {
            throw new IllegalArgumentException("null query");
        }
        if (!query.getGraphPattern().isFullyConnected()) {
            throw new IllegalArgumentException("graph pattern is not fully connected");
        }
        this.queryContext.evictExpired();
        boolean success = false;
        try {
            LinkedList wrappers = new LinkedList();
            GraphPattern<K, V> graphPattern = query.getGraphPattern();
            for (TuplePattern<K, V> tuplePattern : graphPattern.getPatterns()) {
                HashMap indexByKey = new HashMap();
                wrappers.add(this.addTuplePattern(tuplePattern, indexByKey, 0, this.queryContext));
            }
            query.setAllHelpers(wrappers);
            this.queryContext.getQueryExpirationManager().notifyFinishedAdding();
            success = true;
        }
        finally {
            if (!success) {
                logger.warning("query uncleanly added: " + query);
            } else {
                this.queries.add(query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(Query<K, V> query) {
        if (this.queries.remove(query)) {
            boolean success = false;
            try {
                boolean allRemoved = true;
                for (TuplePattern<K, V> tuplePattern : query.getGraphPattern().getPatterns()) {
                    HashMap indexByKey = new HashMap();
                    if (this.removeTuplePattern(tuplePattern, 0, indexByKey)) continue;
                    logger.warning("failed to remove tuple pattern " + tuplePattern + " of query " + query);
                    allRemoved = false;
                }
                boolean bl = success = allRemoved;
                return bl;
            }
            finally {
                if (!success) {
                    logger.warning("query uncleanly removed: " + query);
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return null == this.solutionIndex && null == this.variableIndices && null == this.constantIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(V[] tuple, long expirationTime) {
        this.evictExpired();
        boolean success = false;
        try {
            Object[] values = new Object[tuple.length];
            boolean ret = this.addTuple(tuple, values, 0, 0, expirationTime);
            if (ret) {
                this.queryContext.getSolutionExpirationManager().notifyFinishedAdding();
            }
            success = true;
            boolean bl = ret;
            return bl;
        }
        finally {
            if (!success) {
                logger.warning("tuple uncleanly added");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(V[] tuple) {
        this.evictExpired();
        boolean success = false;
        try {
            Object[] values = new Object[tuple.length];
            boolean ret = this.removeTuple(tuple, values, 0, 0);
            success = true;
            boolean bl = ret;
            return bl;
        }
        finally {
            if (!success) {
                logger.warning("tuple pattern uncleanly removed");
            }
        }
    }

    private void evictExpired() {
        QueryContext<K, V> queryContextSafe = this.queryContext;
        if (null != queryContextSafe) {
            queryContextSafe.evictExpired();
        }
    }

    private synchronized JoinHelper<K, V> addTuplePattern(TuplePattern<K, V> tuplePattern, Map<K, Integer> indexByKey, int depth, QueryContext<K, V> queryContext) {
        QueryIndex<K, V> queryIndex;
        if (depth == tuplePattern.getLength()) {
            if (null == this.solutionIndex) {
                this.solutionIndex = new SolutionIndex<V>(queryContext, indexByKey.size());
            }
            JoinHelper<K, V> helper = new JoinHelper<K, V>(this.solutionIndex, indexByKey);
            tuplePattern.setJoinHelper(helper);
            this.solutionIndex.getConsumerIndex().add(helper);
            return helper;
        }
        VariableOrConstant<K, V> el = tuplePattern.getPattern()[depth];
        K variable = el.getVariable();
        if (null != variable) {
            int offset;
            Integer index;
            if (null == this.variableIndices) {
                this.variableIndices = new QueryIndex[depth + 1];
            }
            if (null == (index = indexByKey.get(variable))) {
                offset = 0;
                indexByKey.put(variable, indexByKey.size());
            } else {
                offset = depth - index;
            }
            queryIndex = this.variableIndices[offset];
            if (null == queryIndex) {
                queryIndex = new QueryIndex<K, V>();
                this.variableIndices[offset] = queryIndex;
            }
        } else {
            V constant = el.getConstant();
            if (null == this.constantIndices) {
                this.constantIndices = new HashMap<V, QueryIndex<K, V>>();
            }
            if (null == (queryIndex = this.constantIndices.get(constant))) {
                queryIndex = new QueryIndex<K, V>();
                this.constantIndices.put((QueryIndex<K, V>)constant, (QueryIndex<V, QueryIndex<K, V>>)queryIndex);
            }
        }
        return super.addTuplePattern(tuplePattern, indexByKey, depth + 1, queryContext);
    }

    private boolean removeTuplePattern(TuplePattern<K, V> tuplePattern, int depth, Map<K, Integer> indexByKey) {
        boolean removed;
        if (depth == tuplePattern.getLength()) {
            if (null == this.solutionIndex) {
                throw new IllegalStateException();
            }
            if (!this.solutionIndex.getConsumerIndex().remove(tuplePattern.getJoinHelper())) {
                throw new IllegalStateException();
            }
            if (this.solutionIndex.getConsumerIndex().isEmpty()) {
                this.solutionIndex = null;
            }
            removed = true;
        } else {
            VariableOrConstant<K, V> vc = tuplePattern.getPattern()[depth];
            K variable = vc.getVariable();
            if (null != variable) {
                int offset;
                if (null == this.variableIndices) {
                    throw new IllegalStateException();
                }
                Integer i = indexByKey.get(variable);
                if (null == i) {
                    offset = 0;
                    indexByKey.put(variable, indexByKey.size());
                } else {
                    offset = depth - i;
                }
                QueryIndex<K, V> index = this.variableIndices[offset];
                if (null == index) {
                    throw new IllegalStateException();
                }
                removed = super.removeTuplePattern(tuplePattern, depth + 1, indexByKey);
                if (removed && index.isEmpty()) {
                    this.variableIndices[offset] = null;
                    boolean nonEmpty = false;
                    for (QueryIndex<K, V> ix : this.variableIndices) {
                        if (null == ix) continue;
                        nonEmpty = true;
                        break;
                    }
                    if (!nonEmpty) {
                        this.variableIndices = null;
                    }
                }
            } else {
                V constant = vc.getConstant();
                QueryIndex<K, V> index = this.constantIndices.get(constant);
                if (null == index) {
                    throw new IllegalStateException();
                }
                removed = super.removeTuplePattern(tuplePattern, depth + 1, indexByKey);
                if (removed && index.isEmpty()) {
                    this.constantIndices.remove(constant);
                    if (this.constantIndices.isEmpty()) {
                        this.constantIndices = null;
                    }
                }
            }
        }
        return removed;
    }

    private boolean addTuple(V[] tuple, V[] values, int tupleDepth, int variableDepth, long expirationTime) {
        boolean added = false;
        SolutionIndex<Object> solutionIndexSafe = this.solutionIndex;
        if (null != solutionIndexSafe) {
            int card = solutionIndexSafe.getCardinality();
            Object[] valuesCopy = new Object[card];
            System.arraycopy(values, 0, valuesCopy, 0, card);
            Solution<Object> solution = new Solution<Object>(valuesCopy, expirationTime, solutionIndexSafe);
            solutionIndexSafe.add(solution);
            added = true;
        }
        if (tupleDepth != tuple.length) {
            QueryIndex<K, V> index;
            Map<V, QueryIndex<K, V>> constantIndicesSafe;
            V value = tuple[tupleDepth];
            QueryIndex<K, V>[] variableIndicesSafe = this.variableIndices;
            if (null != variableIndicesSafe) {
                for (int offset = 0; offset < variableIndicesSafe.length; ++offset) {
                    QueryIndex<K, V> queryIndex = variableIndicesSafe[offset];
                    if (null == queryIndex) continue;
                    if (offset > 0) {
                        if (!value.equals(tuple[tupleDepth - offset])) continue;
                        added |= super.addTuple(tuple, values, tupleDepth + 1, variableDepth, expirationTime);
                        continue;
                    }
                    values[variableDepth] = value;
                    added |= super.addTuple(tuple, values, tupleDepth + 1, variableDepth + 1, expirationTime);
                }
            }
            if (null != (constantIndicesSafe = this.constantIndices) && null != (index = constantIndicesSafe.get(value))) {
                added |= super.addTuple(tuple, values, tupleDepth + 1, variableDepth, expirationTime);
            }
        }
        return added;
    }

    private boolean removeTuple(V[] tuple, V[] values, int tupleDepth, int variableDepth) {
        boolean removed = false;
        SolutionIndex<V> solutionIndexSafe = this.solutionIndex;
        if (null != solutionIndexSafe) {
            removed = solutionIndexSafe.removePattern(values);
        }
        if (tupleDepth != tuple.length) {
            Map<V, QueryIndex<K, V>> constantIndicesSafe;
            V value = tuple[tupleDepth];
            QueryIndex<K, V>[] variableIndicesSafe = this.variableIndices;
            if (null != variableIndicesSafe) {
                for (int offset = 0; offset < variableIndicesSafe.length; ++offset) {
                    QueryIndex<K, V> queryIndex = variableIndicesSafe[offset];
                    if (null == queryIndex) continue;
                    if (offset > 0) {
                        if (!value.equals(tuple[tupleDepth - offset])) continue;
                        removed |= super.removeTuple(tuple, values, tupleDepth + 1, variableDepth);
                        continue;
                    }
                    values[variableDepth] = value;
                    removed |= super.removeTuple(tuple, values, tupleDepth + 1, variableDepth + 1);
                }
            }
            if (null != (constantIndicesSafe = this.constantIndices)) {
                if (null == value) {
                    for (QueryIndex queryIndex : constantIndicesSafe.values()) {
                        removed |= queryIndex.removeTuple(tuple, values, tupleDepth + 1, variableDepth);
                    }
                } else {
                    QueryIndex<K, V> index = constantIndicesSafe.get(value);
                    if (null != index) {
                        removed |= super.removeTuple(tuple, values, tupleDepth + 1, variableDepth);
                    }
                }
            }
        }
        return removed;
    }
}

