/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.model;

public class LList<T> {
    public static final LList NIL = new LList();
    private T value;
    private LList<T> rest;

    private LList() {
        this.value = null;
        this.rest = null;
    }

    private LList(T value, LList<T> rest) {
        this.value = value;
        this.rest = rest;
    }

    public boolean isNil() {
        return null == this.rest;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public LList<T> getRest() {
        return this.rest;
    }

    public void setRest(LList<T> rest) {
        this.rest = rest;
    }

    public LList<T> push(T t) {
        return new LList<T>(t, this);
    }

    public int length() {
        LList<T> cur = this;
        int l = 0;
        while (!cur.isNil()) {
            ++l;
            cur = cur.rest;
        }
        return l;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LList(");
        boolean first = true;
        LList<T> cur = this;
        while (!cur.isNil()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(cur.value);
            cur = cur.rest;
        }
        sb.append(")");
        return sb.toString();
    }
}

