/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Solution;
import net.fortytwo.stream.caching.SolutionPattern;
import net.fortytwo.stream.model.LList;

public class SolutionGroup<T> {
    private final Bindings<T> bindings;
    private LList<SolutionPattern> solutions = LList.NIL;

    public SolutionGroup(Bindings<T> bindings) {
        this.bindings = bindings;
    }

    public Bindings<T> getBindings() {
        return this.bindings;
    }

    public LList<SolutionPattern> getSolutions() {
        return this.solutions;
    }

    public boolean add(Solution<T> sol, long now) {
        if (sol.isExpired(now)) {
            throw new IllegalStateException("we shouldn't add an expired solution");
        }
        LList<SolutionPattern> cur = this.solutions;
        LList<SolutionPattern> prev = null;
        while (!cur.isNil()) {
            boolean removeOld = false;
            SolutionPattern curSol = cur.getValue();
            if (curSol.isExpired(now)) {
                removeOld = true;
            } else {
                SolutionPattern.ContainmentRelation r = curSol.relateTo(sol);
                switch (r) {
                    case Contains: {
                        if (SolutionPattern.compareExpirationTimes(curSol, sol) < 0) break;
                        return false;
                    }
                    case ContainedIn: {
                        if (SolutionPattern.compareExpirationTimes(curSol, sol) > 0) break;
                        removeOld = true;
                        break;
                    }
                    case Equal: {
                        int cmp = SolutionPattern.compareExpirationTimes(curSol, sol);
                        if (cmp < 0) {
                            curSol.setExpirationTime(sol.expirationTime);
                            return true;
                        }
                        return false;
                    }
                    case PartialIntersect: {
                        break;
                    }
                }
            }
            if (removeOld) {
                if (null == prev) {
                    this.solutions = cur.getRest();
                } else {
                    prev.setRest(cur.getRest());
                }
                LList<SolutionPattern> tmp = cur.getRest();
                cur.setRest(null);
                cur = tmp;
                continue;
            }
            prev = cur;
            cur = cur.getRest();
        }
        this.solutions = this.solutions.push(new SolutionPattern(sol));
        return true;
    }

    public int removeExpired(long now) {
        int removed = 0;
        LList<SolutionPattern> cur = this.solutions;
        LList<SolutionPattern> prev = null;
        while (!cur.isNil()) {
            SolutionPattern curPs = cur.getValue();
            if (curPs.isExpired(now)) {
                ++removed;
                if (null == prev) {
                    this.solutions = cur.getRest();
                } else {
                    prev.setRest(cur.getRest());
                }
                cur = cur.getRest();
                continue;
            }
            prev = cur;
            cur = cur.getRest();
        }
        return removed;
    }

    public int hashCode() {
        return this.bindings.getHash();
    }

    public boolean equals(Object other) {
        return other instanceof SolutionGroup && ((SolutionGroup)other).bindings.getHash() == this.bindings.getHash();
    }
}

