/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.Solution;
import net.fortytwo.stream.caching.SolutionIndex;
import net.fortytwo.stream.model.VariableOrConstant;

public class QueryIndex<T, C> {
    private static final Logger logger = Logger.getLogger(QueryIndex.class.getName());
    private Set<Query.PatternInQuery<T, C>> patterns;
    private Map<T, QueryIndex<T, C>> valueIndexes;
    private QueryIndex<T, C> wildcardIndex;
    private final RootMetadata<T, C> rootMetadata;

    public QueryIndex(int tupleSize) {
        this.rootMetadata = new RootMetadata(tupleSize);
    }

    private QueryIndex() {
        this.rootMetadata = null;
    }

    public synchronized void clear() {
        this.wildcardIndex = null;
        this.valueIndexes = null;
        this.patterns = null;
        this.rootMetadata.clear();
    }

    public synchronized void add(Query<T, C> query) {
        this.rootMetadata.add(query);
        logger.fine("adding query " + query.getSubscription());
        for (Query.PatternInQuery<T, C> p : query.getPatterns()) {
            if (((RootMetadata)this.rootMetadata).tupleSize != p.getPattern().length) {
                throw new IllegalArgumentException("tuple pattern is not of expected length " + ((RootMetadata)this.rootMetadata).tupleSize);
            }
            this.add(p, 0);
        }
    }

    public synchronized void remove(Query<T, C> query) {
        logger.fine("removing query " + query.getSubscription());
        if (this.rootMetadata.remove(query)) {
            for (Query.PatternInQuery<T, C> p : query.getPatterns()) {
                this.remove(p, 0);
            }
        } else {
            throw new IllegalArgumentException("no such query");
        }
    }

    public synchronized void renew(Query<T, C> query, int ttl, long now) {
        query.setExpirationTime(0 == ttl ? 0L : now + 1000L * (long)ttl);
        ((RootMetadata)this.rootMetadata).queries.remove(query);
        ((RootMetadata)this.rootMetadata).queries.add(query);
    }

    public boolean add(T[] tuple, BiConsumer<C, Bindings<T>> handler, int ttl, long now) {
        if (((RootMetadata)this.rootMetadata).tupleSize != tuple.length) {
            throw new IllegalArgumentException("tuple is not of expected length " + ((RootMetadata)this.rootMetadata).tupleSize);
        }
        long expirationTime = 0 == ttl ? Long.MAX_VALUE : now + 1000L * (long)ttl;
        return this.add(tuple, this.rootMetadata, handler, expirationTime, now, 0);
    }

    public void removeExpired(long now) {
        long startTime = System.currentTimeMillis();
        int removedSolutions = 0;
        int removedQueries = this.removeExpiredQueries(now);
        for (Query query : ((RootMetadata)this.rootMetadata).queries) {
            SolutionIndex index = query.getSolutionIndex();
            removedSolutions += index.removeExpired(now);
        }
        if (removedQueries > 0 || removedSolutions > 0) {
            long endTime = System.currentTimeMillis();
            logger.info("removed " + removedQueries + " queries and " + removedSolutions + " solutions in " + (endTime - startTime) + "ms");
        }
    }

    private synchronized int removeExpiredQueries(long now) {
        int removedQueries = 0;
        Collection toRemove = ((RootMetadata)this.rootMetadata).queries.stream().filter(query -> query.isExpired(now)).collect(Collectors.toCollection(LinkedList::new));
        for (Query query2 : toRemove) {
            this.remove(query2);
            ++removedQueries;
        }
        return removedQueries;
    }

    private void add(Query.PatternInQuery<T, C> pattern, int level) {
        if (pattern.getPattern().length == level) {
            if (null == this.patterns) {
                this.patterns = new HashSet<Query.PatternInQuery<T, C>>();
            }
            this.patterns.add(pattern);
        } else {
            VariableOrConstant<String, T> term = pattern.getPattern()[level];
            String var = term.getVariable();
            if (null == var) {
                QueryIndex<T, C> idx;
                if (null == this.valueIndexes) {
                    this.valueIndexes = new HashMap<T, QueryIndex<T, C>>();
                }
                if (null == (idx = this.valueIndexes.get(term.getConstant()))) {
                    idx = new QueryIndex<T, C>();
                    this.valueIndexes.put(term.getConstant(), idx);
                }
                super.add(pattern, level + 1);
            } else {
                if (null == this.wildcardIndex) {
                    this.wildcardIndex = new QueryIndex<T, C>();
                }
                super.add(pattern, level + 1);
            }
        }
    }

    private boolean remove(Query.PatternInQuery<T, C> pattern, int level) {
        if (pattern.getPattern().length == level) {
            this.patterns.remove(pattern);
            return 0 == this.patterns.size();
        }
        VariableOrConstant<String, T> term = pattern.getPattern()[level];
        String var = term.getVariable();
        if (null == var) {
            QueryIndex<T, C> idx = this.valueIndexes.get(term.getConstant());
            if (super.remove(pattern, level + 1)) {
                this.valueIndexes.remove(term.getConstant());
            }
        } else if (super.remove(pattern, level + 1)) {
            this.wildcardIndex = null;
        }
        return null == this.wildcardIndex && (null == this.valueIndexes || 0 == this.valueIndexes.size());
    }

    private boolean add(T[] tuple, RootMetadata<T, C> meta, BiConsumer<C, Bindings<T>> handler, long expirationTime, long now, int level) {
        boolean changed = false;
        if (((RootMetadata)meta).tupleSize == level) {
            for (Query.PatternInQuery<T, C> pattern : this.patterns) {
                Stack solutions = new Stack();
                Bindings<T> b = pattern.getQuery().getVariables().bind(pattern.getPattern(), tuple);
                Solution<T> matchedSolution = new Solution<T>(pattern.getQuery().getPatterns().size(), pattern.getIndex(), b, expirationTime);
                pattern.getQuery().getSolutionIndex().joinSolutions(matchedSolution, b, solutions, now);
                for (Solution solution : solutions) {
                    boolean added = pattern.getQuery().getSolutionIndex().add(solution, now);
                    if (added && solution.isComplete()) {
                        handler.accept(pattern.getQuery().getSubscription(), solution.getBindings());
                    }
                    changed |= added;
                }
            }
        } else {
            QueryIndex<T, C> idx;
            if (null != this.wildcardIndex) {
                changed = super.add(tuple, meta, handler, expirationTime, now, level + 1);
            }
            if (null != this.valueIndexes && null != (idx = this.valueIndexes.get(tuple[level]))) {
                changed |= super.add(tuple, meta, handler, expirationTime, now, level + 1);
            }
        }
        return changed;
    }

    private static class RootMetadata<T, C> {
        private final int tupleSize;
        private final PriorityQueue<Query<T, C>> queries = new PriorityQueue();

        private RootMetadata(int tupleSize) {
            this.tupleSize = tupleSize;
        }

        public void clear() {
            this.queries.clear();
        }

        public void add(Query<T, C> query) {
            this.queries.add(query);
        }

        public boolean remove(Query<T, C> query) {
            return this.queries.remove(query);
        }
    }
}

