/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.SolutionIndex;
import net.fortytwo.stream.model.VariableOrConstant;

public class Query<T, S>
implements Comparable<Query<T, S>> {
    private final List<PatternInQuery<T, S>> patterns;
    private final QueryVariables variables;
    private S subscription;
    private long expirationTime;
    private final SolutionIndex<T> solutionIndex;

    public Query(List<VariableOrConstant<String, T>[]> patterns, long expirationTime) {
        if (0 == patterns.size()) {
            throw new IllegalArgumentException("a query must contain at least one tuple pattern");
        }
        if (patterns.size() > 32) {
            throw new IllegalArgumentException("too many tuple patterns; implementation limit is 32 per query");
        }
        this.patterns = new LinkedList<PatternInQuery<T, S>>();
        this.expirationTime = expirationTime;
        int i = 0;
        int tupleSize = patterns.get(0).length;
        HashSet<String> variableSet = new HashSet<String>();
        for (VariableOrConstant[] variableOrConstantArray : patterns) {
            int size = variableOrConstantArray.length;
            if (size != tupleSize) {
                throw new IllegalArgumentException("inconsistent length of tuple patterns");
            }
            PatternInQuery pattern = new PatternInQuery(this, variableOrConstantArray, i++);
            this.patterns.add(pattern);
            for (VariableOrConstant t : variableOrConstantArray) {
                String v = (String)t.getVariable();
                if (null == v) continue;
                variableSet.add(v);
            }
        }
        this.variables = new QueryVariables(variableSet);
        this.solutionIndex = new SolutionIndex(this.variables, patterns.size());
    }

    public S getSubscription() {
        return this.subscription;
    }

    public void setSubscription(S subscription) {
        this.subscription = subscription;
    }

    public List<PatternInQuery<T, S>> getPatterns() {
        return this.patterns;
    }

    public QueryVariables getVariables() {
        return this.variables;
    }

    public SolutionIndex<T> getSolutionIndex() {
        return this.solutionIndex;
    }

    public boolean isExpired(long now) {
        return this.expirationTime > 0L && this.expirationTime < now;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public int compareTo(Query<T, S> other) {
        return 0L == this.expirationTime ? (0L == other.expirationTime ? 0 : 1) : (0L == other.expirationTime ? -1 : Long.valueOf(this.expirationTime).compareTo(other.expirationTime));
    }

    public static class PatternInQuery<T, C> {
        private final VariableOrConstant<String, T>[] pattern;
        private final Query<T, C> query;
        private final int index;

        private PatternInQuery(Query<T, C> query, VariableOrConstant<String, T>[] pattern, int index) {
            this.query = query;
            this.pattern = pattern;
            this.index = index;
        }

        public Query<T, C> getQuery() {
            return this.query;
        }

        public VariableOrConstant<String, T>[] getPattern() {
            return this.pattern;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class QueryVariables {
        private final String[] variables;
        private final Map<String, Integer> variableIndices;

        public QueryVariables(Collection<String> coll) {
            this.variables = coll.toArray(new String[coll.size()]);
            this.variableIndices = new HashMap<String, Integer>();
            for (int i = 0; i < this.variables.length; ++i) {
                this.variableIndices.put(this.variables[i], i);
            }
        }

        public String[] asArray() {
            return this.variables;
        }

        public int indexOf(String variable) {
            Integer i = this.variableIndices.get(variable);
            if (null == i) {
                throw new NoSuchElementException("no such variable: " + variable);
            }
            return i;
        }

        public <T> Bindings<T> bind(VariableOrConstant<String, T>[] pattern, T[] tuple) {
            HashMap<String, T> bindings = new HashMap<String, T>();
            for (int i = 0; i < pattern.length; ++i) {
                String v = pattern[i].getVariable();
                if (null == v) continue;
                bindings.put(v, tuple[i]);
            }
            return new Bindings(bindings, this);
        }
    }
}

