/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fortytwo.stream.caching.Query;

public class Bindings<T> {
    private final Map<String, T> map;
    private final int domainBitfield;
    private Integer hash;

    public Bindings(Map<String, T> map, Query.QueryVariables vars) {
        this.map = map;
        int b = 0;
        for (String v : map.keySet()) {
            int i = vars.indexOf(v);
            b |= 1 << i;
        }
        this.domainBitfield = b;
    }

    private Bindings(Map<String, T> map, int domainBitfield) {
        this.map = map;
        this.domainBitfield = domainBitfield;
    }

    public int getHash() {
        if (null == this.hash) {
            int h = 0;
            for (Map.Entry<String, T> e : this.map.entrySet()) {
                h += e.getKey().hashCode() * e.getValue().hashCode();
            }
            this.hash = h;
        }
        return this.hash;
    }

    public static <T> Bindings<T> from(Bindings<T> first, Bindings<T> second) {
        int x = first.domainBitfield ^ second.domainBitfield;
        if (0 == x) {
            if (first.domainBitfield == second.domainBitfield) {
                return first;
            }
        } else {
            if (0 == (first.domainBitfield & x)) {
                return second;
            }
            if (0 == (second.domainBitfield & x)) {
                return first;
            }
        }
        int boundVariables = first.domainBitfield | second.domainBitfield;
        HashMap<String, T> bindings = new HashMap<String, T>();
        bindings.putAll(first.map);
        bindings.putAll(second.map);
        return new Bindings(bindings, boundVariables);
    }

    public T get(String variable) {
        return this.map.get(variable);
    }

    public Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean compatibleWith(Bindings<T> other, Query.QueryVariables vars) {
        String[] a;
        int b = this.domainBitfield & other.domainBitfield;
        for (String v : a = vars.asArray()) {
            if (0 != (b & 1) && !this.map.get(v).equals(other.map.get(v))) {
                return false;
            }
            b >>= 1;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, T> e : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(e.getKey()).append(":").append(e.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return this.getHash();
    }

    public boolean equals(Object other) {
        return other instanceof Bindings && ((Bindings)other).getHash() == this.getHash();
    }
}

