/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream;

import java.io.IOException;
import java.util.function.BiConsumer;
import net.fortytwo.stream.BasicStreamProcessor;
import net.fortytwo.stream.Subscription;

public class BasicSubscription<C, Q, S>
implements Subscription {
    private static int nextId = 0;
    private final C sparqlQuery;
    private Q query;
    private BiConsumer<S, Long> solutionConsumer;
    private final BasicStreamProcessor<?, C, Q, ?, S> processor;
    private boolean active;
    private final String id;

    private static synchronized String getNextId() {
        return Integer.valueOf(nextId++).toString();
    }

    private BasicSubscription(String id, C sparqlQuery, Q query, BiConsumer<S, Long> consumer, BasicStreamProcessor<?, C, Q, ?, S> processor) {
        this.id = id;
        this.sparqlQuery = sparqlQuery;
        this.query = query;
        this.solutionConsumer = consumer;
        this.processor = processor;
        this.active = true;
    }

    public BasicSubscription(C sparqlQuery, Q query, BiConsumer<S, Long> solutionConsumer, BasicStreamProcessor<?, C, Q, ?, S> processor) {
        this(BasicSubscription.getNextId(), sparqlQuery, query, solutionConsumer, processor);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void cancel() throws IOException {
        this.active = false;
        this.processor.unregister(this);
    }

    @Override
    public boolean renew(int ttl) throws IOException {
        return this.isActive() && this.processor.renew(this, ttl);
    }

    public C getConstraint() {
        return this.sparqlQuery;
    }

    public Q getQuery() {
        return this.query;
    }

    public BiConsumer<S, Long> getSolutionConsumer() {
        return this.solutionConsumer;
    }

    public void setQuery(Q query) {
        this.query = query;
    }

    public void setSolutionConsumer(BiConsumer<S, Long> solutionConsumer) {
        this.solutionConsumer = solutionConsumer;
    }
}

