/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fortytwo.stream.model.VariableOrConstant;
import net.fortytwo.stream.shj.ExpirationManager;
import net.fortytwo.stream.shj.GraphPattern;
import net.fortytwo.stream.shj.Index;
import net.fortytwo.stream.shj.JoinHelper;
import net.fortytwo.stream.shj.Query;
import net.fortytwo.stream.shj.QueryContext;
import net.fortytwo.stream.shj.QueryIndex;
import net.fortytwo.stream.shj.Solution;
import net.fortytwo.stream.shj.TuplePattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SHJTestBase {
    protected ExpirationManager<Solution<String>> solutionExpirationManager;
    private ExpirationManager<Query<String, String>> queryExpirationManager;
    private long simTime;
    protected final Random random = new Random();
    protected QueryContext<String, String> context;
    protected QueryIndex<String, String> queryIndex;
    private final Map<String, Set<CompleteSolution<String, String>>> solutionsByName = new HashMap<String, Set<CompleteSolution<String, String>>>();
    private final Index<Solution<String>> noopIndex = new Index<Solution<String>>(){

        public void add(Solution<String> toAdd) {
        }

        public boolean remove(Solution<String> toRemove) {
            return false;
        }

        public void clear() {
        }

        public boolean isEmpty() {
            return false;
        }
    };

    @Before
    public void setUp() {
        this.solutionsByName.clear();
        this.queryExpirationManager = new ExpirationManager<Query<String, String>>(){

            protected long getNow() {
                return SHJTestBase.this.simTime;
            }
        };
        this.queryExpirationManager.setVerbose(true);
        this.solutionExpirationManager = new ExpirationManager<Solution<String>>(){

            protected long getNow() {
                return SHJTestBase.this.simTime;
            }
        };
        this.solutionExpirationManager.setVerbose(true);
        this.context = new QueryContext(this.queryExpirationManager, this.solutionExpirationManager);
        this.queryIndex = new QueryIndex(this.context);
    }

    @After
    public void tearDown() {
        this.queryExpirationManager.stop();
        this.solutionExpirationManager.stop();
    }

    protected long setCurrentTime(long now) {
        this.simTime = now;
        return this.simTime;
    }

    protected Solution<String> newSolution(String[] values) {
        return new Solution((Object[])values, Long.MAX_VALUE, this.noopIndex);
    }

    protected Solution<String> newSolution(String[] values, long expTime) {
        return new Solution((Object[])values, expTime, this.noopIndex);
    }

    protected Solution<String> randomSolution(int tupleLength, long expTime) {
        Object[] values = new String[tupleLength];
        for (int i = 0; i < values.length; ++i) {
            values[i] = "value" + this.random.nextInt();
        }
        return new Solution(values, expTime, this.noopIndex);
    }

    protected GraphPattern<String, String> graphPattern(TuplePattern<String, String> ... patterns) {
        if (0 == patterns.length) {
            throw new IllegalArgumentException();
        }
        return new GraphPattern(patterns);
    }

    protected TuplePattern<String, String> tuplePattern(String ... values) {
        VariableOrConstant[] pattern = new VariableOrConstant[values.length];
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            pattern[i] = value.startsWith("?") ? new VariableOrConstant((Object)value, null) : new VariableOrConstant(null, (Object)value);
        }
        return new TuplePattern(pattern);
    }

    protected String[] tuple(String ... values) {
        return values;
    }

    protected BiConsumer<Map<String, String>, Long> createConsumer(String name) {
        return (mapping, expTime) -> {
            Set<CompleteSolution<String, String>> set = this.solutionsByName.get(name);
            if (null == set) {
                set = new HashSet<CompleteSolution<String, String>>();
                this.solutionsByName.put(name, set);
            }
            CompleteSolution comp = new CompleteSolution((Map)mapping, (long)expTime);
            set.add(comp);
        };
    }

    protected Query<String, String> addQuery(String name, GraphPattern<String, String> pattern) {
        Query query = new Query(pattern, Long.MAX_VALUE, (Index)this.context.getQueryExpirationManager(), this.createConsumer(name));
        this.queryIndex.add(query);
        List consumers = query.getAllHelpers();
        Assert.assertEquals((long)pattern.getPatterns().length, (long)consumers.size());
        return query;
    }

    protected void expectQuerySolutions(String queryName, int expectedCount) {
        Set<CompleteSolution<String, String>> sols = this.solutionsByName.get(queryName);
        if (0 == expectedCount) {
            Assert.assertNull(sols);
        } else {
            Assert.assertNotNull(sols);
            Assert.assertEquals((long)expectedCount, (long)sols.size());
        }
    }

    protected void expectIndexSolutions(JoinHelper<String, String> consumer, int expectedCount) {
        Set solutions = consumer.getSolutions();
        Assert.assertEquals((long)expectedCount, (long)solutions.size());
    }

    protected void expectSolutions(JoinHelper<String, String> consumer, int expectedCount, String key, String value) {
        Set solutions = consumer.getSolutions((Object)key, (Object)value);
        if (0 == expectedCount) {
            Assert.assertNull((Object)solutions);
        } else {
            Assert.assertNotNull((Object)solutions);
            Assert.assertEquals((long)expectedCount, (long)solutions.size());
        }
    }

    protected static class CompleteSolution<K, V> {
        public final Map<K, V> mapping;
        public final long expirationTime;

        private CompleteSolution(Map<K, V> mapping, long expirationTime) {
            this.mapping = mapping;
            this.expirationTime = expirationTime;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof CompleteSolution)) {
                return false;
            }
            CompleteSolution otherCS = (CompleteSolution)other;
            if (this.mapping.size() != otherCS.mapping.size()) {
                return false;
            }
            if (this.hashCode() != otherCS.hashCode()) {
                return false;
            }
            for (Map.Entry<K, V> e : this.mapping.entrySet()) {
                V val = otherCS.mapping.get(e.getKey());
                if (null != val && val.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hc = 0;
            for (Map.Entry<K, V> e : this.mapping.entrySet()) {
                hc += e.getKey().hashCode() * e.getValue().hashCode();
            }
            return hc;
        }
    }
}

