/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.List;
import net.fortytwo.stream.shj.JoinHelper;
import net.fortytwo.stream.shj.SHJTestBase;
import net.fortytwo.stream.shj.TuplePattern;
import org.junit.Assert;
import org.junit.Test;

public class QueryTest
extends SHJTestBase {
    @Test
    public void testQueriesWithSinglePattern() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "?p", "?y"))).getAllHelpers();
        List consumers2 = this.addQuery("query2", this.graphPattern(this.tuplePattern("?x", "knows", "Ford"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer2a = (JoinHelper)consumers2.get(0);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?p", "?y"}, (Object[])consumer1a.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?x"}, (Object[])consumer2a.getKeys());
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?x", "Arthur");
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?p", "knows");
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?y", "Ford");
        this.expectQuerySolutions("query1", 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2a, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer2a, 1, "?x", "Arthur");
        this.expectSolutions((JoinHelper<String, String>)consumer2a, 0, "?p", "knows");
        this.expectSolutions((JoinHelper<String, String>)consumer2a, 0, "?y", "Ford");
        this.expectQuerySolutions("query2", 1);
    }

    @Test
    public void testQueryWithMultiplePatterns() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "name", "'Ford Prefect'"), this.tuplePattern("?y", "nickname", "'Ix'"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        JoinHelper consumer1c = (JoinHelper)consumers1.get(2);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y"}, (Object[])consumer1a.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?y"}, (Object[])consumer1b.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?y"}, (Object[])consumer1c.getKeys());
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?x", "Arthur");
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?y", "Ford");
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 0);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Ford", "nickname", "'Ix'"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1c, 1, "?y", "Ford");
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Ford", "name", "'Ford Prefect'"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1b, 1, "?y", "Ford");
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 1);
        this.expectQuerySolutions("query1", 1);
    }

    @Test
    public void testQueryWithVaryingTupleAndPatternLengths() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "name", "'Ford Prefect'", "g1"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y"}, (Object[])consumer1a.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?y"}, (Object[])consumer1b.getKeys());
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?x", "Arthur");
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?y", "Ford");
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Ford", "name", "'Ford Prefect'"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Ford", "name", "'Ford Prefect'", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1b, 1, "?y", "Ford");
        this.expectQuerySolutions("query1", 1);
        this.queryIndex.add((Object[])this.tuple("Zaphod", "knows", "Ford", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 2);
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?x", "Arthur");
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 1, "?x", "Zaphod");
        this.expectSolutions((JoinHelper<String, String>)consumer1a, 2, "?y", "Ford");
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 1);
        this.expectQuerySolutions("query1", 2);
    }

    @Test
    public void testEquivalentQueries() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y", "g"))).getAllHelpers();
        JoinHelper consumer1 = (JoinHelper)consumers1.get(0);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y"}, (Object[])consumer1.getKeys());
        List consumers2 = this.addQuery("query2", this.graphPattern(this.tuplePattern("?a", "knows", "?b", "g"))).getAllHelpers();
        JoinHelper consumer2 = (JoinHelper)consumers2.get(0);
        Assert.assertArrayEquals((Object[])new String[]{"?a", "?b"}, (Object[])consumer2.getKeys());
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford", "g"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1, 1, "?x", "Arthur");
        this.expectSolutions((JoinHelper<String, String>)consumer1, 0, "?x", "Ford");
        this.expectSolutions((JoinHelper<String, String>)consumer1, 1, "?y", "Ford");
        this.expectSolutions((JoinHelper<String, String>)consumer1, 0, "?z", "Arthur");
        this.expectQuerySolutions("query1", 1);
        this.expectQuerySolutions("query2", 1);
        this.queryIndex.add((Object[])this.tuple("Zaphod", "knows", "Ford", "g"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1, 2);
        this.expectSolutions((JoinHelper<String, String>)consumer1, 2, "?y", "Ford");
        this.expectSolutions((JoinHelper<String, String>)consumer1, 0, "?x", "Ford");
        this.expectSolutions((JoinHelper<String, String>)consumer1, 0, "?y", "Arthur");
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2, 2);
        this.expectSolutions((JoinHelper<String, String>)consumer2, 2, "?b", "Ford");
        this.expectQuerySolutions("query1", 2);
        this.expectQuerySolutions("query2", 2);
    }

    @Test
    public void testTuplePatternWithRepeatedVariables() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "likes", "?x", "?g"))).getAllHelpers();
        JoinHelper consumer1 = (JoinHelper)consumers1.get(0);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?g"}, (Object[])consumer1.getKeys());
        this.queryIndex.add((Object[])this.tuple("Eddie", "likes", "Eddie", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1, 1);
        this.expectSolutions((JoinHelper<String, String>)consumer1, 1, "?x", "Eddie");
        this.expectQuerySolutions("query1", 1);
        this.queryIndex.add((Object[])this.tuple("Zaphod", "likes", "Zaphod", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1, 2);
        this.expectSolutions((JoinHelper<String, String>)consumer1, 1, "?x", "Zaphod");
        this.expectQuerySolutions("query1", 2);
        this.queryIndex.add((Object[])this.tuple("Eddie", "likes", "Arthur", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1, 2);
        this.expectQuerySolutions("query1", 2);
        this.queryIndex.add((Object[])this.tuple("Arthur", "likes", "Eddie", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1, 2);
        this.expectSolutions((JoinHelper<String, String>)consumer1, 1, "?x", "Eddie");
        this.expectSolutions((JoinHelper<String, String>)consumer1, 0, "?x", "Arthur");
        this.expectQuerySolutions("query1", 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyQueryIsRejected() {
        this.addQuery("query1", this.graphPattern(new TuplePattern[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryWithEmptyTuplePatternIsRejected() {
        this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern(new String[0])));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryWithUnconnectedPatternsIsRejected() {
        this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?z", "knows", "?a"), this.tuplePattern("?z", "nickname", "'Ix")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryWithVariableUnconnectedPatternsIsRejected() {
        this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "Ford"), this.tuplePattern("?y", "knows", "Ford")));
    }

    @Test
    public void testQueriesWithOverlappingPatterns() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        List consumers2 = this.addQuery("query2", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "likes", "Everything"))).getAllHelpers();
        JoinHelper consumer2a = (JoinHelper)consumers2.get(0);
        JoinHelper consumer2b = (JoinHelper)consumers2.get(1);
        List consumers3 = this.addQuery("query3", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?x", "name", "'Arthur Dent'"))).getAllHelpers();
        JoinHelper consumer3a = (JoinHelper)consumers3.get(0);
        JoinHelper consumer3b = (JoinHelper)consumers3.get(1);
        this.queryIndex.add((Object[])this.tuple("France", "capitalCity", "Paris"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3b, 0);
        this.expectQuerySolutions("query1", 0);
        this.expectQuerySolutions("query2", 0);
        this.expectQuerySolutions("query3", 0);
        this.queryIndex.add((Object[])this.tuple("Arthur", "name", "'Arthur Dent'"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3b, 1);
        this.expectQuerySolutions("query1", 0);
        this.expectQuerySolutions("query2", 0);
        this.expectQuerySolutions("query3", 0);
        this.queryIndex.add((Object[])this.tuple("Caesar", "knows", "Brutus"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3b, 1);
        this.expectQuerySolutions("query1", 1);
        this.expectQuerySolutions("query2", 0);
        this.expectQuerySolutions("query3", 0);
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2a, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer2b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3a, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer3b, 1);
        this.expectQuerySolutions("query1", 2);
        this.expectQuerySolutions("query2", 0);
        this.expectQuerySolutions("query3", 1);
    }

    @Test
    public void testQueriesWithIdenticalPatterns() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "likes", "?y", "?g"), this.tuplePattern("?x", "likes", "?y"), this.tuplePattern("?x", "likes", "?y"), this.tuplePattern("?y", "name", "'Tricia McMillan'"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        JoinHelper consumer1c = (JoinHelper)consumers1.get(2);
        JoinHelper consumer1d = (JoinHelper)consumers1.get(3);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y", "?g"}, (Object[])consumer1a.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y"}, (Object[])consumer1b.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y"}, (Object[])consumer1c.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?y"}, (Object[])consumer1d.getKeys());
        this.queryIndex.add((Object[])this.tuple("Eddie", "name", "'Eddie'"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 0);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Trillian", "name", "'Tricia McMillan'"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 1);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Arthur", "likes", "Trillian"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 1);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Zaphod", "likes", "Trillian", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 1);
        this.expectQuerySolutions("query1", 1);
        this.queryIndex.add((Object[])this.tuple("Arthur", "likes", "Trillian", "g1"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 1);
        this.expectQuerySolutions("query1", 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueriesWithNoVariablePatterns() {
        this.addQuery("query1", this.graphPattern(this.tuplePattern("Arthur", "likes", "Trillian")));
    }

    @Test
    public void testCircularQuery() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "knows", "?z"), this.tuplePattern("?z", "knows", "?a"), this.tuplePattern("?a", "knows", "?x"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        JoinHelper consumer1c = (JoinHelper)consumers1.get(2);
        JoinHelper consumer1d = (JoinHelper)consumers1.get(3);
        Assert.assertArrayEquals((Object[])new String[]{"?x", "?y"}, (Object[])consumer1a.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?y", "?z"}, (Object[])consumer1b.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?z", "?a"}, (Object[])consumer1c.getKeys());
        Assert.assertArrayEquals((Object[])new String[]{"?a", "?x"}, (Object[])consumer1d.getKeys());
        this.queryIndex.add((Object[])this.tuple("Arthur", "likes", "Trillian"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 0);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 0);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 1);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 1);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Ford", "knows", "Zaphod"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 2);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 2);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Zaphod", "knows", "Trillian"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 3);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 3);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 3);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 3);
        this.expectQuerySolutions("query1", 0);
        this.queryIndex.add((Object[])this.tuple("Trillian", "knows", "Arthur"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 4);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 4);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 4);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 4);
        this.expectQuerySolutions("query1", 4);
        this.queryIndex.add((Object[])this.tuple("Trillian", "knows", "Arthur"), Long.MAX_VALUE);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 4);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 4);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 4);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 4);
        this.expectQuerySolutions("query1", 4);
    }

    @Test
    public void testPathQueries1() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        this.addExampleTuples();
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 7);
        this.expectQuerySolutions("query1", 7);
    }

    @Test
    public void testPathQueries2() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "knows", "?z"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        this.addExampleTuples();
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 7);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 7);
        this.expectQuerySolutions("query1", 10);
    }

    @Test
    public void testPathQueries3() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "knows", "?z"), this.tuplePattern("?z", "knows", "?a"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        JoinHelper consumer1c = (JoinHelper)consumers1.get(2);
        this.addExampleTuples();
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 7);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 7);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 7);
        this.expectQuerySolutions("query1", 17);
    }

    @Test
    public void testPathQueries4() {
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "knows", "?z"), this.tuplePattern("?z", "knows", "?a"), this.tuplePattern("?a", "knows", "?b"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        JoinHelper consumer1c = (JoinHelper)consumers1.get(2);
        JoinHelper consumer1d = (JoinHelper)consumers1.get(3);
        this.addExampleTuples();
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1a, 7);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1b, 7);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1c, 7);
        this.expectIndexSolutions((JoinHelper<String, String>)consumer1d, 7);
        this.expectQuerySolutions("query1", 27);
    }

    private void addExampleTuples() {
        for (Object[] objectArray : new String[][]{{"Arthur", "knows", "Trillian"}, {"Arthur", "knows", "Marvin"}, {"Arthur", "knows", "Ford"}, {"Arthur", "knows", "Zaphod"}, {"Ford", "knows", "Arthur"}, {"Ford", "knows", "Zaphod"}, {"Zaphod", "knows", "Ford"}}) {
            this.queryIndex.add(objectArray, Long.MAX_VALUE);
        }
    }

    private void addLessExampleTuples() {
        for (Object[] objectArray : new String[][]{{"Arthur", "knows", "Ford"}, {"Ford", "knows", "Arthur"}}) {
            this.queryIndex.add(objectArray, Long.MAX_VALUE);
        }
    }
}

