/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import net.fortytwo.stream.shj.SHJTestBase;
import net.fortytwo.stream.shj.Solution;
import org.junit.Test;

public class ExpirationManagerIT
extends SHJTestBase {
    @Test
    public void testEvictionRate() throws Exception {
        long span = 1000L;
        long maxTtl = span * 10L;
        for (int i = 1; i <= 10; ++i) {
            this.solutionExpirationManager.clear();
            int total = i * 100000;
            for (int j = 0; j < total; ++j) {
                long ttl = 1L + (long)(this.random.nextDouble() * (double)maxTtl);
                this.solutionExpirationManager.add(this.randomSolution(4, ttl));
            }
            int size = this.solutionExpirationManager.getHeapSize();
            long before = System.currentTimeMillis();
            this.setCurrentTime(span);
            int evictCount = this.solutionExpirationManager.evictExpired();
            long after = System.currentTimeMillis();
            if (evictCount <= 0) continue;
            System.out.println("###\t\tevicted " + evictCount + " of " + size + " items in " + (after - before) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvictionThread() {
        this.solutionExpirationManager.start();
        try {
            long now;
            long stopAt = System.currentTimeMillis() + 10000L;
            long maxTtl = 10000L;
            while ((now = this.setCurrentTime(System.currentTimeMillis())) < stopAt) {
                this.solutionExpirationManager.evictExpired();
                long ttl = (long)(this.random.nextDouble() * (double)maxTtl);
                Solution<String> d = this.randomSolution(4, now + ttl);
                this.solutionExpirationManager.add(d);
                this.solutionExpirationManager.notifyFinishedAdding();
            }
        }
        finally {
            this.solutionExpirationManager.stop();
        }
    }

    @Test
    public void testEvictionThreadWithoutExplicitCall() {
        long now;
        this.solutionExpirationManager.start();
        long stopAt = System.currentTimeMillis() + 10000L;
        long maxTtl = 10000L;
        while ((now = this.setCurrentTime(System.currentTimeMillis())) < stopAt) {
            long ttl = (long)(this.random.nextDouble() * (double)maxTtl);
            Solution<String> d = this.randomSolution(4, now + ttl);
            this.solutionExpirationManager.add(d);
            this.solutionExpirationManager.notifyFinishedAdding();
        }
    }
}

