/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.Solution;
import org.junit.Assert;
import org.junit.Test;

public class SolutionTest {
    private final long exp = 0L;

    @Test
    public void testCompatibility() throws Exception {
        Query.QueryVariables vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        map1.put("y", "green");
        Bindings b1 = new Bindings(map1, vars);
        Solution ps1 = new Solution(3, 0, b1, 0L);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("x", "red");
        map2.put("y", "green");
        Bindings b2 = new Bindings(map2, vars);
        Solution ps2 = new Solution(3, 1, b2, 0L);
        Assert.assertTrue((boolean)ps1.composableWith(ps2, vars));
        Assert.assertTrue((boolean)ps2.composableWith(ps1, vars));
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("y", "blue");
        b2 = new Bindings(map2, vars);
        ps2 = new Solution(3, 1, b2, 0L);
        Assert.assertFalse((boolean)ps1.composableWith(ps2, vars));
        Assert.assertFalse((boolean)ps2.composableWith(ps1, vars));
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("z", "blue");
        b2 = new Bindings(map2, vars);
        ps2 = new Solution(3, 1, b2, 0L);
        Assert.assertTrue((boolean)ps1.composableWith(ps2, vars));
        Assert.assertTrue((boolean)ps2.composableWith(ps1, vars));
        map2 = new HashMap();
        map2.put("z", "blue");
        b2 = new Bindings(map2, vars);
        ps2 = new Solution(3, 1, b2, 0L);
        Assert.assertTrue((boolean)ps1.composableWith(ps2, vars));
        Assert.assertTrue((boolean)ps2.composableWith(ps1, vars));
        map2 = new HashMap();
        map2.put("z", "blue");
        b2 = new Bindings(map2, vars);
        ps2 = new Solution(3, 0, b2, 0L);
        Assert.assertFalse((boolean)ps1.composableWith(ps2, vars));
        Assert.assertFalse((boolean)ps2.composableWith(ps1, vars));
    }

    @Test(expected=NoSuchElementException.class)
    public void testInvalidVariables() {
        Query.QueryVariables vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        map1.put("y", "green");
        Bindings b1 = new Bindings(map1, vars);
        Solution ps1 = new Solution(3, 0, b1, 0L);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("a", "red");
        map2.put("b", "green");
        Bindings b2 = new Bindings(map2, vars);
        Solution ps2 = new Solution(3, 0, b2, 0L);
        ps1.composableWith(ps2, vars);
    }
}

