/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.sparql;

import java.util.Collection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;

public class SimpleJSONRDFFormat {
    private static final String FIELD_BNODE = "bnode";
    private static final String FIELD_DATATYPE = "datatype";
    private static final String FIELD_LANG = "lang";
    private static final String FIELD_LITERAL = "literal";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_IRI = "iri";
    private static final String FIELD_VALUE = "value";
    private final ValueFactory valueFactory;

    public SimpleJSONRDFFormat(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public JSONArray statementsToJSON(Statement ... statements) throws JSONException {
        JSONArray all = new JSONArray();
        int count = 0;
        for (Statement s : statements) {
            all.put(count++, (Object)this.toJSON(s));
        }
        return all;
    }

    public JSONArray statementsToJSON(Collection<Statement> statements) throws JSONException {
        JSONArray all = new JSONArray();
        int count = 0;
        for (Statement s : statements) {
            all.put(count++, (Object)this.toJSON(s));
        }
        return all;
    }

    private JSONArray toJSON(Statement s) throws JSONException {
        JSONArray a = new JSONArray();
        a.put(0, (Object)this.toJSON((Value)s.getSubject()));
        a.put(1, (Object)this.toJSON((Value)s.getPredicate()));
        a.put(2, (Object)this.toJSON(s.getObject()));
        if (null != s.getContext()) {
            a.put(3, (Object)s.getContext());
        }
        return a;
    }

    private JSONObject toJSON(Value v) throws JSONException {
        JSONObject j = new JSONObject();
        if (v instanceof Literal) {
            j.put(FIELD_VALUE, (Object)v.stringValue());
            j.put(FIELD_TYPE, (Object)FIELD_LITERAL);
            Literal l = (Literal)v;
            if (null != l.getLanguage()) {
                j.put(FIELD_LANG, (Object)l.getLanguage());
            } else if (null != l.getDatatype()) {
                j.put(FIELD_DATATYPE, (Object)l.getDatatype().stringValue());
            }
        } else if (v instanceof BNode) {
            j.put(FIELD_VALUE, (Object)("_:" + ((BNode)v).getID()));
            j.put(FIELD_TYPE, (Object)FIELD_BNODE);
        } else if (v instanceof IRI) {
            j.put(FIELD_VALUE, (Object)v.stringValue());
            j.put(FIELD_TYPE, (Object)FIELD_IRI);
        } else {
            throw new IllegalStateException("value is of unexpected type: " + v);
        }
        return j;
    }

    public Value fromJSON(JSONObject j) throws ParseError {
        BNode object;
        block5: {
            try {
                String type = j.getString(FIELD_TYPE);
                String value = j.getString(FIELD_VALUE);
                if (FIELD_LITERAL.equals(type)) {
                    String lang = j.optString(FIELD_LANG);
                    String datatype = j.optString(FIELD_DATATYPE);
                    object = lang != null ? this.valueFactory.createLiteral(value, lang) : (datatype != null ? this.valueFactory.createLiteral(value, this.valueFactory.createIRI(datatype)) : this.valueFactory.createLiteral(value));
                    break block5;
                }
                if (FIELD_BNODE.equals(type)) {
                    object = this.valueFactory.createBNode(value.substring(2));
                    break block5;
                }
                if (FIELD_IRI.equals(type)) {
                    object = this.valueFactory.createIRI(value);
                    break block5;
                }
                throw new ParseError("unexpected type: " + type);
            }
            catch (JSONException e) {
                throw new ParseError(e);
            }
        }
        return object;
    }

    public BindingSet toBindingSet(JSONObject bindings) throws ParseError {
        try {
            MapBindingSet bs = new MapBindingSet();
            Iterator keys = bindings.keys();
            while (keys.hasNext()) {
                Object key = keys.next();
                if (!(key instanceof String)) {
                    throw new ParseError("String expected as key");
                }
                JSONObject value = bindings.getJSONObject((String)key);
                Value v = this.fromJSON(value);
                bs.addBinding((String)key, v);
            }
            return bs;
        }
        catch (JSONException e) {
            throw new ParseError(e);
        }
    }

    public JSONObject toJSON(BindingSet solution, Long expirationTime) throws JSONException {
        JSONObject j = new JSONObject();
        JSONObject solutionObj = new JSONObject();
        for (Binding b : solution) {
            solutionObj.put(b.getName(), (Object)this.toJSON(b.getValue()));
        }
        j.put("solution", (Object)solutionObj);
        j.put("expirationTime", (Object)expirationTime);
        return j;
    }

    public Statement toStatement(JSONArray a) throws ParseError {
        int l = a.length();
        if (l < 3 || l > 4) {
            throw new ParseError("triple/quad must have three or four elements");
        }
        try {
            Value context;
            Value subject = this.fromJSON(a.getJSONObject(0));
            Value predicate = this.fromJSON(a.getJSONObject(1));
            Value object = this.fromJSON(a.getJSONObject(2));
            Value value = context = 4 == l ? this.fromJSON(a.getJSONObject(3)) : null;
            if (!(subject instanceof Resource)) {
                throw new ParseError("subject of statement must be an RDF resource");
            }
            if (!(predicate instanceof IRI)) {
                throw new ParseError("predicate of statement must be a IRI");
            }
            if (null != context && !(context instanceof Resource)) {
                throw new ParseError("graph context of statement must be an RDF resource");
            }
            return this.valueFactory.createStatement((Resource)subject, (IRI)predicate, object, (Resource)context);
        }
        catch (JSONException e) {
            throw new ParseError(e);
        }
    }

    public static class ParseError
    extends Exception {
        public ParseError(String message) {
            super(message);
        }

        public ParseError(Throwable cause) {
            super(cause);
        }
    }
}

