/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.osc.udp;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPortOut;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.smsn.p2p.osc.OscSender;

public class UdpOscSender
implements OscSender {
    private static final Logger logger = Logger.getLogger(UdpOscSender.class.getName());
    private final OSCPortOut oscPortOut;

    public UdpOscSender(String hostOut, int portOut) throws UnknownHostException, SocketException {
        InetAddress outAddress = null == hostOut || hostOut.equals("localhost") || hostOut.equals("127.0.0.1") ? InetAddress.getLocalHost() : InetAddress.getByName(hostOut);
        this.oscPortOut = new OSCPortOut(outAddress, portOut);
    }

    @Override
    public void send(OSCBundle bundle) {
        try {
            this.oscPortOut.send((OSCPacket)bundle);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "failed to send OSC bundle", e);
        }
    }

    @Override
    public void close() {
    }
}

