/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.osc.slip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlipOutputStream {
    private static final Logger logger = Logger.getLogger(SlipOutputStream.class.getName());
    private static final int SLIP_END = 192;
    private static final int SLIP_ESC = 219;
    private static final int SLIP_ESC_END = 220;
    private static final int SLIP_ESC_ESC = 221;
    private final OutputStream outputStream;
    private LinkedBlockingQueue<byte[]> queue;
    private Thread thread;
    private long throttlingPeriod;
    private long timeOfLastPacket;

    public SlipOutputStream(OutputStream outputStream, boolean threaded) {
        this.outputStream = outputStream;
        LinkedBlockingQueue linkedBlockingQueue = this.queue = threaded ? new LinkedBlockingQueue() : null;
        if (threaded) {
            this.thread = new Thread(() -> {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        byte[] packet = this.queue.take();
                        this.sendInternal(packet);
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "I/O exception while writing SLIP packet", e);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "unexpected error in ThreadedSlipOutputStream. Quitting thread", t);
                }
            });
            this.thread.start();
        }
    }

    public void setThrottlingPeriod(long throttlingPeriod) {
        this.throttlingPeriod = throttlingPeriod;
    }

    public SlipOutputStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public void send(byte[] packet) throws IOException {
        if (null == this.queue) {
            this.sendInternal(packet);
        } else {
            this.queue.add(packet);
        }
    }

    private void sendInternal(byte[] packet) throws IOException {
        this.throttle();
        for (byte b : packet) {
            if (-64 == b) {
                this.outputStream.write(-37);
                this.outputStream.write(-36);
                continue;
            }
            if (-37 == b) {
                this.outputStream.write(-37);
                this.outputStream.write(-35);
                continue;
            }
            this.outputStream.write(b);
        }
        this.outputStream.write(-64);
    }

    private void throttle() {
        if (this.throttlingPeriod > 0L) {
            long now = System.currentTimeMillis();
            if (now - this.timeOfLastPacket < this.throttlingPeriod) {
                try {
                    Thread.sleep(this.throttlingPeriod - (now - this.timeOfLastPacket));
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.timeOfLastPacket = now;
        }
    }

    public void close() throws IOException {
        this.outputStream.close();
        if (null != this.queue) {
            this.queue = null;
            this.thread.interrupt();
        }
    }
}

