/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.osc.slip;

import com.illposed.osc.OSCBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.smsn.p2p.osc.OscSender;
import net.fortytwo.smsn.p2p.osc.slip.SlipOutputStream;

public class SlipOscSender
implements OscSender {
    private static final Logger logger = Logger.getLogger(SlipOscSender.class.getName());
    private static final int SPP_PAYLOAD_CAPACITY = 128;
    private final SlipOutputStream slipStream;

    public SlipOscSender(SlipOutputStream slipStream) {
        this.slipStream = slipStream;
    }

    public SlipOscSender(OutputStream outputStream, boolean threaded) {
        this(new SlipOutputStream(outputStream, threaded));
    }

    @Override
    public synchronized void send(OSCBundle bundle) {
        if (null == this.slipStream) {
            logger.log(Level.WARNING, "can't send OSC message; no output stream");
        } else {
            try {
                byte[] bytes = bundle.getByteArray();
                if (bytes.length >= 128) {
                    logger.log(Level.WARNING, "message length (" + bytes.length + " bytes) should be kept well under Bluetooth SPP payload capacity (128 bytes)");
                }
                this.slipStream.send(bundle.getByteArray());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "I/O error while sending OSC message", e);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.slipStream.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error on closing of SLIP stream", e);
        }
    }
}

