/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.osc.slip;

import java.io.IOException;
import java.io.InputStream;

public class SlipInputStream {
    private static final int DEFAULT_BUFFER_LENGTH = 1500;
    private static final int SLIP_END = 192;
    private static final int SLIP_ESC = 219;
    private static final int SLIP_ESC_END = 220;
    private static final int SLIP_ESC_ESC = 221;
    private final InputStream inputStream;
    private final int bufferLength;

    public SlipInputStream(InputStream inputStream, int bufferLength) {
        this.inputStream = inputStream;
        this.bufferLength = bufferLength;
    }

    public SlipInputStream(InputStream inputStream) {
        this(inputStream, 1500);
    }

    public void receive(PacketHandler handler) throws IOException, PacketHandlerException {
        int b;
        byte[] buffer = new byte[this.bufferLength];
        while (192 != (b = this.inputStream.read())) {
            if (-1 != b) continue;
            return;
        }
        int i = 0;
        while (-1 != (b = this.inputStream.read())) {
            if (192 == b) {
                if (i > 0) {
                    try {
                        handler.handle(buffer, i);
                    }
                    catch (Exception e) {
                        throw new PacketHandlerException(e);
                    }
                }
                i = 0;
                continue;
            }
            if (this.bufferLength == i) {
                throw new IOException("buffer size of " + this.bufferLength + " exceeded");
            }
            if (219 == b) {
                b = this.inputStream.read();
                if (-1 == b) break;
                if (220 == b) {
                    buffer[i++] = -64;
                    continue;
                }
                if (221 == b) {
                    buffer[i++] = -37;
                    continue;
                }
                throw new IOException("illegal escape sequence: found byte " + b + " after SLIP_ESC");
            }
            buffer[i++] = (byte)b;
        }
    }

    public static class PacketHandlerException
    extends Exception {
        private PacketHandlerException(Throwable cause) {
            super(cause);
        }
    }

    public static interface PacketHandler {
        public void handle(byte[] var1, int var2);
    }
}

