/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.osc;

import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.smsn.p2p.osc.OscMessageHandler;

public class OscReceiver {
    private static final Logger logger = Logger.getLogger(OscReceiver.class.getName());
    private final Map<String, OscMessageHandler> handlers = new HashMap<String, OscMessageHandler>();
    private final Set<OSCMessageListener> listeners = new HashSet<OSCMessageListener>();

    public void register(String oscAddress, OscMessageHandler handler) {
        this.handlers.put(oscAddress, handler);
    }

    public void addListener(OSCMessageListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OSCMessageListener listener) {
        this.listeners.remove(listener);
    }

    public boolean receive(OSCMessage message) {
        boolean handled;
        OscMessageHandler handler = this.handlers.get(message.getAddress());
        if (null == handler) {
            handled = false;
        } else {
            handler.handle(message);
            handled = true;
        }
        for (OSCMessageListener listener : this.listeners) {
            listener.handle(message);
        }
        return handled;
    }

    public boolean receive(OSCPacket p) {
        if (p instanceof OSCMessage) {
            return this.receive((OSCMessage)p);
        }
        logger.log(Level.WARNING, "OSC packet is of non-message type " + p.getClass().getSimpleName() + ": " + p);
        return false;
    }

    public boolean receive(byte[] data, int length) {
        OSCByteArrayToJavaConverter c = new OSCByteArrayToJavaConverter();
        OSCPacket p = c.convert(data, length);
        return this.receive(p);
    }

    public static interface OSCMessageListener {
        public void handle(OSCMessage var1);
    }
}

