/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p.osc;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.smsn.p2p.osc.OscReceiver;
import net.fortytwo.smsn.p2p.osc.OscSender;
import net.fortytwo.smsn.p2p.osc.slip.SlipOscSender;

public abstract class OscControl {
    protected static final Logger logger = Logger.getLogger(SlipOscSender.class.getName());
    protected final OscReceiver receiver;
    private OscSender sender;
    private long throttlingPeriod = 100L;
    private long timeOfLastPacket;
    protected long timeOfLastEvent;
    private BlockingQueue<OSCMessage> messages;

    protected OscControl(OscReceiver receiver) {
        this.receiver = receiver;
    }

    public OscReceiver getReceiver() {
        return this.receiver;
    }

    public void setThrottlingPeriod(long throttlingPeriod) {
        if (0L > throttlingPeriod) {
            throw new IllegalArgumentException();
        }
        this.throttlingPeriod = throttlingPeriod;
    }

    public void throttleAsynchronously(int bufferCapacity) {
        if (1 >= bufferCapacity) {
            throw new IllegalArgumentException();
        }
        if (0L == this.throttlingPeriod) {
            throw new IllegalStateException("throttling period must be positive");
        }
        OscControl self = this;
        this.messages = new LinkedBlockingQueue<OSCMessage>(bufferCapacity);
        new Thread(() -> {
            try {
                while (self.throttlingPeriod > 0L) {
                    OSCMessage message = this.messages.take();
                    this.throttle();
                    this.sendInternal(message);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "message throttling thread died with error", t);
            }
        }).start();
    }

    public void connect(OscSender sender) {
        this.sender = sender;
        this.onConnect();
    }

    public synchronized void disconnect() {
        if (null != this.sender) {
            this.sender.close();
            this.sender = null;
        }
    }

    protected void onConnect() {
    }

    public synchronized void send(OSCMessage message) {
        if (null == this.sender) {
            logger.warning("can't send message with address " + message.getAddress() + "; no sender has been defined");
        } else if (null != this.messages) {
            this.messages.offer(message);
        } else {
            if (this.throttlingPeriod > 0L) {
                this.throttle();
            }
            this.sendInternal(message);
        }
    }

    private void sendInternal(OSCMessage message) {
        OSCBundle bundle = new OSCBundle();
        bundle.addPacket((OSCPacket)message);
        this.sender.send(bundle);
    }

    private void throttle() {
        long now = System.currentTimeMillis();
        if (now - this.timeOfLastPacket < this.throttlingPeriod) {
            try {
                Thread.sleep(this.throttlingPeriod - (now - this.timeOfLastPacket));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        this.timeOfLastPacket = now;
    }

    public class DeviceInitializationException
    extends Exception {
        public DeviceInitializationException(Throwable cause) {
            super(cause);
        }

        public DeviceInitializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

