/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import org.json.JSONException;
import org.json.JSONObject;

public class ServiceDescription {
    private static final String PROP_ENDPOINT = "endpoint";
    private static final String PROP_OSC_PORT = "oscPort";
    private static final String PROP_PUBSUB_PORT = "pubsubPort";
    private static final String PROP_VERSION = "version";
    private final String endpoint;
    private final int oscPort;
    private final int pubsubPort;
    private final String version;

    public ServiceDescription(String version, String endpoint, int oscPort, int pubsubPort) {
        this.endpoint = endpoint;
        this.oscPort = oscPort;
        this.pubsubPort = pubsubPort;
        this.version = version;
    }

    public ServiceDescription(String jsonStr) throws InvalidServiceDescriptionException {
        try {
            JSONObject j = new JSONObject(jsonStr);
            this.endpoint = j.getString(PROP_ENDPOINT);
            this.version = j.getString(PROP_VERSION);
            this.oscPort = j.getInt(PROP_OSC_PORT);
            this.pubsubPort = j.getInt(PROP_PUBSUB_PORT);
        }
        catch (NumberFormatException | JSONException e) {
            throw new InvalidServiceDescriptionException(e.getMessage());
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getOscPort() {
        return this.oscPort;
    }

    public int getPubsubPort() {
        return this.pubsubPort;
    }

    public String getVersion() {
        return this.version;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject j = new JSONObject();
        j.put(PROP_VERSION, (Object)this.version);
        j.put(PROP_ENDPOINT, (Object)this.endpoint);
        j.put(PROP_OSC_PORT, this.oscPort);
        j.put(PROP_PUBSUB_PORT, this.pubsubPort);
        return j;
    }

    public class InvalidServiceDescriptionException
    extends Exception {
        public InvalidServiceDescriptionException(String message) {
            super(message);
        }
    }
}

