/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.logging.Logger;
import net.fortytwo.smsn.SemanticSynchrony;
import net.fortytwo.smsn.config.Service;
import net.fortytwo.smsn.p2p.ServiceDescription;
import org.json.JSONException;
import org.json.JSONObject;

public class ServiceBroadcaster {
    private static final Logger logger = Logger.getLogger(ServiceBroadcaster.class.getName());
    private static final long MAX_BACKOFF = 60000L;
    private final ServiceDescription serviceDescription;
    private boolean stopped;

    public ServiceBroadcaster(ServiceDescription serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void start() {
        this.stopped = false;
        new Thread(() -> {
            logger.info("starting service broadcaster thread");
            try {
                this.sendBroadcastMessages();
            }
            catch (Throwable t) {
                logger.severe("service broadcaster thread failed with error: " + t.getMessage());
                t.printStackTrace(System.err);
            }
            finally {
                logger.info("service broadcaster thread stopped");
            }
        }).start();
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastMessages() {
        JSONObject j;
        Service config = SemanticSynchrony.getConfiguration().getServices().getBroadcast();
        String address = config.getHost();
        int port = config.getPort();
        long broadcastInterval = config.getInterval();
        try {
            j = this.serviceDescription.toJSON();
        }
        catch (JSONException e) {
            logger.severe("error creating JSON content of broadcast message: " + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }
        byte[] buffer = j.toString().getBytes();
        long backoff = broadcastInterval;
        while (!this.stopped) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length, InetAddress.getByName(address), port);
                socket.setBroadcast(true);
                try (DatagramSocket socket = new DatagramSocket();){
                    while (!this.stopped) {
                        logger.fine("sending broadcast message: " + j);
                        socket.send(packet);
                        backoff = broadcastInterval;
                        try {
                            Thread.sleep(broadcastInterval);
                        }
                        catch (InterruptedException e) {
                            logger.warning("error while waiting to send next broadcast: " + e.getMessage());
                            e.printStackTrace(System.err);
                            socket.close();
                            return;
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.warning("error while sending broadcast message(s): " + e.getMessage());
                if ((backoff *= 2L) > 60000L) {
                    backoff = 60000L;
                }
                logger.info("waiting " + backoff + "ms before next broadcast");
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e2) {
                    logger.warning("error while waiting to reopen broadcast socket: " + e.getMessage());
                    e2.printStackTrace(System.err);
                    return;
                }
            }
        }
    }
}

