/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.logging.Logger;
import net.fortytwo.smsn.SemanticSynchrony;
import net.fortytwo.smsn.config.Service;
import net.fortytwo.smsn.p2p.ServiceDescription;

public class ServiceBroadcastListener {
    private static final Logger logger = Logger.getLogger(ServiceBroadcastListener.class.getName());
    private static final int BROADCAST_MAX_LENGTH = 1000;
    private final EventHandler eventHandler;
    private boolean stopped;

    public ServiceBroadcastListener(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void start() {
        this.stopped = false;
        new Thread(() -> {
            logger.info("starting listener thread for coordinator broadcast messages");
            try {
                this.listenForCoordinatorBroadcast();
            }
            catch (Throwable t) {
                logger.severe("listener thread for coordinator broadcast messages failed with error: " + t.getMessage());
                t.printStackTrace(System.err);
            }
            finally {
                logger.info("listener thread for coordinator broadcast messages stopped");
            }
        }).start();
    }

    public void stop() {
        this.stopped = true;
    }

    private void listenForCoordinatorBroadcast() {
        Service config = SemanticSynchrony.getConfiguration().getServices().getBroadcast();
        int port = config.getPort();
        byte[] buffer = new byte[1000];
        try {
            DatagramPacket dataIn = new DatagramPacket(buffer, buffer.length);
            try (DatagramSocket socket = new DatagramSocket(port);){
                socket.setSoTimeout(0);
                while (!this.stopped) {
                    socket.receive(dataIn);
                    String msg = new String(buffer).substring(0, dataIn.getLength());
                    if (!msg.startsWith("{") || !msg.endsWith("}")) continue;
                    logger.fine("UDP message received: " + msg);
                    try {
                        ServiceDescription d = new ServiceDescription(msg);
                        this.eventHandler.receivedServiceDescription(dataIn.getAddress(), d);
                    }
                    catch (ServiceDescription.InvalidServiceDescriptionException e) {
                        logger.warning("invalid service description in datagram from " + dataIn.getAddress().getHostAddress() + ": " + msg);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.severe("IOException while waiting for broadcast datagram from coordinator: " + e.getMessage());
        }
    }

    public static interface EventHandler {
        public void receivedServiceDescription(InetAddress var1, ServiceDescription var2);
    }
}

