/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.IOException;
import net.fortytwo.smsn.p2p.Connection;
import net.fortytwo.smsn.p2p.MessageHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class Pinger {
    public static final String PING = "ping";
    public static final String PING_REPLY = "ping-reply";
    private final Connection connection;
    private long before;
    private PingResultHandler resultHandler;

    public Pinger(Connection connection) {
        this.connection = connection;
        connection.registerHandler(PING_REPLY, new PingReplyHandler());
    }

    public synchronized void ping(PingResultHandler handler) throws IOException, JSONException {
        this.resultHandler = handler;
        JSONObject message = new JSONObject();
        this.before = System.currentTimeMillis();
        this.connection.sendNow(PING, message);
    }

    public static interface PingResultHandler {
        public void handleResult(long var1);
    }

    private class PingReplyHandler
    implements MessageHandler {
        private PingReplyHandler() {
        }

        @Override
        public void handle(JSONObject message) {
            long after = System.currentTimeMillis();
            Pinger.this.resultHandler.handleResult(after - Pinger.this.before);
        }
    }
}

