/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.logging.Logger;

public class ExampleSubscriber {
    private static final Logger logger = Logger.getLogger(ExampleSubscriber.class.getName());

    private ExampleSubscriber() {
        try {
            this.listenForNotifications();
        }
        catch (Throwable e) {
            logger.severe("SPARQL notification listener stream closed with error: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private void listenForNotifications() throws IOException {
        String host = "localhost";
        int portNumber = 4201;
        logger.info("creating socket to 'localhost' on port 4201");
        block0: while (true) {
            logger.info("opening SPARQL notification socket for reading");
            Socket socket = new Socket("localhost", 4201);
            BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while (true) {
                String line;
                if (null == (line = br.readLine())) continue block0;
                System.out.println("notification from coordinator: " + line);
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        new ExampleSubscriber();
    }
}

