/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

public class ExampleBroadcaster {
    private void sendExampleDataset() throws RDFHandlerException, IOException, JSONException {
        String endpoint = "http://localhost:8182/graphs/joshkb/smsn/broadcast-rdf";
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RDFWriter w = Rio.createWriter((RDFFormat)RDFFormat.NTRIPLES, (OutputStream)bos);
        w.startRDF();
        w.handleStatement(vf.createStatement((Resource)RDF.TYPE, RDFS.LABEL, (Value)vf.createLiteral("type")));
        w.handleStatement(vf.createStatement((Resource)RDF.TYPE, RDFS.CLASS, (Value)RDF.PROPERTY));
        w.endRDF();
        String content = bos.toString();
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost method = new HttpPost(endpoint);
        JSONObject r = new JSONObject();
        r.put("dataset", (Object)content);
        method.getParams().setParameter("request", (Object)r.toString());
        HttpResponse response = client.execute((HttpUriRequest)method);
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        System.out.println("response body: " + responseBody);
        method.releaseConnection();
    }

    public static void main(String[] args) throws Exception {
        new ExampleBroadcaster().sendExampleDataset();
    }
}

