/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.fortytwo.smsn.p2p.Connection;

public class ConnectionHost {
    protected static final Logger logger = Logger.getLogger(ConnectionHost.class.getName());
    private final Set<Notifier> notifiers;
    private final Set<Connection> connections = new HashSet<Connection>();
    private boolean stopped = true;
    private final int port;

    public ConnectionHost(int port) {
        this.port = port;
        this.notifiers = new HashSet<Notifier>();
    }

    public void addNotifier(Notifier notifier) {
        this.notifiers.add(notifier);
    }

    public synchronized void start() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        new Thread(() -> {
            logger.info("starting connection listener thread on port " + this.port);
            try {
                this.listenForNewConnections();
            }
            catch (Throwable e) {
                logger.severe("connection listener thread on port " + this.port + " failed with error: " + e.getMessage());
                e.printStackTrace(System.err);
            }
            finally {
                logger.info("connection listener thread on port " + this.port + " has stopped");
            }
        }).start();
    }

    public synchronized void stop() {
        try {
            this.closeAllConnections();
        }
        catch (IOException e) {
            logger.warning("error while closing connection(s): " + e.getMessage());
            e.printStackTrace(System.err);
        }
        this.stopped = true;
    }

    private void listenForNewConnections() throws IOException {
        logger.info("listening for new connections on port " + this.port);
        ServerSocket serverSocket = new ServerSocket(this.port);
        while (!this.stopped) {
            Socket socket = serverSocket.accept();
            Connection c = new Connection();
            c.start(socket);
            logger.info("new pub/sub connection opened to " + socket.getRemoteSocketAddress() + " (" + socket.getInetAddress() + ")");
            for (Notifier notifier : this.notifiers) {
                notifier.connectionCreated(c);
            }
        }
    }

    private void closeAllConnections() throws IOException {
        for (Connection c : this.connections) {
            if (c.getSocket().isClosed()) continue;
            c.getSocket().close();
        }
        this.connections.clear();
    }

    public static interface Notifier {
        public void connectionCreated(Connection var1);
    }
}

