/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.smsn.p2p;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.smsn.SemanticSynchrony;
import net.fortytwo.smsn.p2p.MessageHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class Connection {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    private Socket socket;
    private final Map<String, MessageHandler> handlers = new HashMap<String, MessageHandler>();
    private final List<BufferedMessage> buffer = new LinkedList<BufferedMessage>();
    private boolean stopped = false;

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isActive() {
        return null != this.socket;
    }

    private void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized void start(Socket socket) {
        if (this.isActive()) {
            throw new IllegalStateException("connection is already active");
        }
        this.setSocket(socket);
        for (BufferedMessage bm : this.buffer) {
            try {
                this.sendInternal(bm.tag, bm.body);
            }
            catch (IOException | JSONException e) {
                logger.log(Level.WARNING, "error sending buffered message", e);
            }
        }
        this.buffer.clear();
        this.stopped = false;
        new Thread(() -> {
            logger.info("starting message handler thread");
            try {
                this.handleIncomingMessages();
            }
            catch (Throwable e) {
                logger.severe("message handler thread failed with error: " + e.getMessage());
                e.printStackTrace(System.err);
            }
            finally {
                logger.info("message handler thread stopped");
            }
            this.setSocket(null);
        }).start();
    }

    public synchronized void stop() {
        if (!this.isActive()) {
            throw new IllegalStateException("connection is not active");
        }
        this.stopped = true;
    }

    public void registerHandler(String tag, MessageHandler handler) {
        if (null != this.handlers.get(tag)) {
            throw new IllegalStateException("a '" + tag + "' handler is already registered with this connection");
        }
        this.handlers.put(tag, handler);
    }

    public synchronized void sendNow(String tag, JSONObject body) throws JSONException, IOException {
        if (!this.isActive()) {
            logger.fine("can't send; connection is closed");
            return;
        }
        this.sendInternal(tag, body);
    }

    public synchronized void sendBuffered(String tag, JSONObject body) throws IOException, JSONException {
        if (this.isActive()) {
            this.sendInternal(tag, body);
        } else {
            BufferedMessage bm = new BufferedMessage();
            bm.tag = tag;
            bm.body = body;
            this.buffer.add(bm);
        }
    }

    private void sendInternal(String tag, JSONObject body) throws JSONException, IOException {
        JSONObject message = new JSONObject();
        message.put("tag", (Object)tag);
        message.put("body", (Object)body);
        String s = message.toString();
        if (SemanticSynchrony.getConfiguration().isVerbose()) {
            logger.info("sending message to " + this.socket.getRemoteSocketAddress() + ": " + s);
        }
        this.socket.getOutputStream().write(s.getBytes());
        this.socket.getOutputStream().write(10);
        this.socket.getOutputStream().flush();
    }

    private void close() throws IOException {
        this.socket.close();
        this.socket = null;
    }

    private void handleIncomingMessages() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        while (!this.stopped) {
            JSONObject body;
            String tag;
            JSONObject message;
            String line = br.readLine();
            if (null == line) {
                logger.info("connection to " + this.socket.getRemoteSocketAddress() + " closed remotely");
                break;
            }
            if (SemanticSynchrony.getConfiguration().isVerbose()) {
                logger.info("received message from " + this.socket.getRemoteSocketAddress() + ": " + line);
            }
            try {
                message = new JSONObject(line);
            }
            catch (JSONException e) {
                logger.warning("could not parse message as JSON: " + e.getMessage());
                continue;
            }
            try {
                tag = message.getString("tag");
            }
            catch (JSONException e) {
                logger.warning("missing 'tag' in JSON message. Discarding");
                continue;
            }
            try {
                body = message.getJSONObject("body");
            }
            catch (JSONException e) {
                logger.warning("missing 'body' in JSON message. Discarding");
                continue;
            }
            MessageHandler handler = this.handlers.get(tag);
            if (null == handler) {
                logger.warning("no handler for message with tag '" + tag + "'");
                continue;
            }
            try {
                handler.handle(body);
            }
            catch (MessageHandler.MessageHandlerException e) {
                logger.severe("JSON message handler failed with error: " + e.getMessage());
            }
            catch (Throwable t) {
                logger.severe("JSON message handler failed with unexpected error: " + t.getMessage());
                t.printStackTrace(System.err);
            }
        }
        this.close();
    }

    private class BufferedMessage {
        public String tag;
        public JSONObject body;

        private BufferedMessage() {
        }
    }
}

