/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.core.Specifier;
import jade.mtp.xmpp.MessageTransportProtocol;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.wrapper.AgentContainer;
import java.io.IOException;
import java.util.Properties;
import net.fortytwo.rdfagents.data.DatasetFactory;
import net.fortytwo.rdfagents.model.RDFAgentsPlatform;

public class RDFAgentsPlatformImpl
extends RDFAgentsPlatform {
    private static final String MTPS = "mtps";
    public static final String HTTP_MTP_OUTPORT = "jade_http_mtp_outPort";
    public static final String XMPP_MTP_SERVER = "jade_mtp_xmpp_server";
    public static final String XMPP_MTP_USERNAME = "jade_mtp_xmpp_username";
    public static final String XMPP_MTP_PASSWORD = "jade_mtp_xmpp_passwd";
    private final AgentContainer container;
    private final Runtime runtime = Runtime.instance();

    public RDFAgentsPlatformImpl(String name, DatasetFactory datasetFactory, int port, Properties config) {
        super(name, datasetFactory);
        this.runtime.setCloseVM(true);
        ProfileImpl p = new ProfileImpl(null, port, name);
        LinkedList mtps = new LinkedList();
        Specifier http = new Specifier();
        String httpPort = config.getProperty(HTTP_MTP_OUTPORT);
        if (null != httpPort) {
            p.setParameter(HTTP_MTP_OUTPORT, httpPort);
        }
        http.setClassName(jade.mtp.http.MessageTransportProtocol.class.getName());
        mtps.add((Object)http);
        if (null != config.get(XMPP_MTP_SERVER)) {
            p.setParameter(XMPP_MTP_SERVER, config.getProperty(XMPP_MTP_SERVER));
            p.setParameter(XMPP_MTP_USERNAME, config.getProperty(XMPP_MTP_USERNAME));
            p.setParameter(XMPP_MTP_PASSWORD, config.getProperty(XMPP_MTP_PASSWORD));
            Specifier xmpp = new Specifier();
            xmpp.setClassName(MessageTransportProtocol.class.getName());
            mtps.add((Object)xmpp);
        }
        p.setSpecifiers(MTPS, (List)mtps);
        System.out.println("Launching JADE container for RDFAgents: " + p);
        this.container = this.runtime.createMainContainer((Profile)p);
    }

    public RDFAgentsPlatformImpl(String name, int port, Properties config) throws IOException {
        this(name, new DatasetFactory(), port, config);
    }

    public AgentContainer getContainer() {
        return this.container;
    }

    public void shutDown() {
        this.runtime.shutDown();
    }

    public static class CondVar {
        private boolean value = false;

        synchronized void waitOn() throws InterruptedException {
            while (!this.value) {
                this.wait();
            }
        }

        synchronized void signal() {
            this.value = true;
            this.notifyAll();
        }
    }
}

