/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.wrapper.StaleProxyException;
import net.fortytwo.rdfagents.jade.RDFAgentImpl;
import net.fortytwo.rdfagents.jade.RDFJadeAgent;
import net.fortytwo.rdfagents.messaging.CancellationCallback;
import net.fortytwo.rdfagents.messaging.ConsumerCallback;
import net.fortytwo.rdfagents.messaging.LocalFailure;
import net.fortytwo.rdfagents.messaging.subscribe.PubsubConsumer;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.RDFAgent;
import org.openrdf.model.Value;

public class PubsubConsumerImpl
extends PubsubConsumer<Value, Dataset> {
    public PubsubConsumerImpl(RDFAgent agent) {
        super(agent);
        if (!(agent instanceof RDFAgentImpl)) {
            throw new IllegalArgumentException("expected RDFAgent implementation " + RDFAgentImpl.class.getName() + ", found " + agent.getClass().getName());
        }
    }

    public String submit(Value topic, AgentId publisher, ConsumerCallback<Dataset> callback) throws LocalFailure {
        try {
            RDFJadeAgent.Task t = ((RDFAgentImpl)this.agent).subscribe(topic, publisher, callback);
            ((RDFAgentImpl)this.agent).putObject(t);
            return t.getConversationId();
        }
        catch (StaleProxyException e) {
            throw new LocalFailure((Throwable)e);
        }
    }

    public void cancel(String conversationId, AgentId publisher, CancellationCallback callback) throws LocalFailure {
        try {
            RDFJadeAgent.Task t = ((RDFAgentImpl)this.agent).cancelSubscription(conversationId, publisher, callback);
            ((RDFAgentImpl)this.agent).putObject(t);
        }
        catch (StaleProxyException e) {
            throw new LocalFailure((Throwable)e);
        }
    }
}

