/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.content.ContentManager;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Logger;
import net.fortytwo.rdfagents.RDFAgents;
import net.fortytwo.rdfagents.data.DatasetFactory;
import net.fortytwo.rdfagents.jade.RDFAgentsOntology;
import net.fortytwo.rdfagents.messaging.LocalFailure;
import net.fortytwo.rdfagents.messaging.MessageNotUnderstoodException;
import net.fortytwo.rdfagents.messaging.MessageRejectedException;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.ErrorExplanation;
import net.fortytwo.rdfagents.model.RDFContentLanguage;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class MessageFactory {
    private static final Logger logger = Logger.getLogger(MessageFactory.class.getName());
    private final Random random = new Random();
    private final ValueFactory valueFactory;
    private final DatasetFactory datasetFactory;
    private final ContentManager contentManager;
    private final SLCodec sl2Codec;
    private final Ontology rdfAgentsOntology;

    public MessageFactory(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
        this.valueFactory = datasetFactory.getValueFactory();
        this.contentManager = new ContentManager();
        this.sl2Codec = new SLCodec(2, false);
        this.contentManager.registerLanguage((Codec)this.sl2Codec);
        this.rdfAgentsOntology = RDFAgentsOntology.getInstance();
        this.contentManager.registerOntology(this.rdfAgentsOntology, "rdfagents");
    }

    public Value extractDescribeQuery(ACLMessage message) throws MessageNotUnderstoodException, LocalFailure {
        AbsContentElement el = this.extractAbsContent(message);
        if (!(el instanceof AbsIRE)) {
            throw new MessageNotUnderstoodException("expected IdentifyingReferenceExpression was not found in content: " + message.getContent());
        }
        try {
            String typeName;
            AbsIRE any = (AbsIRE)el;
            String name1 = any.getVariable().getName();
            AbsPredicate pred = any.getProposition();
            AbsTerm d = pred.getAbsTerm("dataset");
            String name2 = ((AbsVariable)d).getName();
            if (!name1.equals(name2)) {
                throw new MessageNotUnderstoodException("variable names do not match in query: " + message.getContent());
            }
            AbsTerm term = pred.getAbsTerm("subject");
            switch (typeName = term.getTypeName()) {
                case "resource": {
                    return this.toResource(term, message);
                }
                case "literal": {
                    return this.toLiteral(term, message);
                }
            }
            throw new MessageNotUnderstoodException("resource of unexpected type in query: " + message.getContent());
        }
        catch (ClassCastException | NullPointerException e) {
            throw new MessageNotUnderstoodException("invalid content for this type of message: " + message.getContent());
        }
    }

    public ErrorExplanation extractErrorExplanation(ACLMessage message) throws MessageNotUnderstoodException, LocalFailure {
        AbsContentElement el = this.extractAbsContent(message);
        if (!(el instanceof AbsPredicate)) {
            throw new MessageNotUnderstoodException("expected explanation predicate was not found in content: " + message.getContent());
        }
        AbsPredicate exp = (AbsPredicate)el;
        ErrorExplanation.Type type = ErrorExplanation.Type.getByFipaName((String)exp.getTypeName());
        if (null == type) {
            throw new MessageNotUnderstoodException("unexpected explanation type '" + exp.getTypeName() + " in content: " + message.getContent());
        }
        try {
            String msg = exp.getAbsTerm("message").toString();
            return new ErrorExplanation(type, msg);
        }
        catch (ClassCastException | NullPointerException e) {
            throw new MessageNotUnderstoodException("invalid content for this type of message: " + message.getContent());
        }
    }

    public Dataset extractDataset(ACLMessage message) throws MessageNotUnderstoodException, LocalFailure {
        RDFContentLanguage language = this.getRDFContentLanguage(message);
        this.assertRDFAgentsProtocolWithConvoId(message);
        String content = message.getContent();
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        try {
            Dataset sendersDataset = this.datasetFactory.parse((InputStream)in, language);
            Dataset dataset = this.datasetFactory.receiveDataset(sendersDataset, this.fromAID(message.getSender()));
            return dataset;
        }
        catch (DatasetFactory.InvalidRDFContentException e) {
            throw new MessageNotUnderstoodException(e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new LocalFailure((Throwable)e);
            }
        }
    }

    public ACLMessage notUnderstood(ACLMessage replyTo, AgentId sender, AgentId intendedReceiver, ErrorExplanation explanation) {
        ACLMessage message = this.createReplyTo(replyTo, sender, intendedReceiver, 10);
        try {
            this.addExplanation(message, explanation);
        }
        catch (LocalFailure e) {
            logger.severe("failed to generate not-understood message: " + (Object)((Object)e));
        }
        return message;
    }

    public ACLMessage failure(AgentId sender, AgentId intendedReceiver, ACLMessage request, ErrorExplanation explanation) {
        ACLMessage message = this.createReplyTo(request, sender, intendedReceiver, 6);
        try {
            this.addExplanation(message, explanation);
        }
        catch (LocalFailure e) {
            logger.severe("failed to generate failure message: " + (Object)((Object)e));
        }
        return message;
    }

    public ACLMessage poseQuery(AgentId sender, AgentId intendedReceiver, Value subject, RDFContentLanguage ... acceptLanguages) throws LocalFailure {
        return this.requestForInfo(sender, intendedReceiver, subject, "fipa-query", 13, acceptLanguages);
    }

    public ACLMessage refuseToAnswerQuery(AgentId sender, AgentId intendedReceiver, ACLMessage replyTo, ErrorExplanation explanation) throws MessageNotUnderstoodException, LocalFailure {
        this.validateMessage(replyTo, "fipa-query", 13);
        ACLMessage message = this.createReplyTo(replyTo, sender, intendedReceiver, 14);
        this.addExplanation(message, explanation);
        return message;
    }

    public ACLMessage agreeToAnswerQuery(AgentId sender, AgentId intendedReceiver, ACLMessage replyTo) throws MessageNotUnderstoodException {
        this.validateMessage(replyTo, "fipa-query", 13);
        return this.createReplyTo(replyTo, sender, intendedReceiver, 1);
    }

    public ACLMessage informOfQueryResult(AgentId sender, AgentId intendedReceiver, ACLMessage replyTo, Dataset dataset, RDFContentLanguage defaultLanguage) throws MessageNotUnderstoodException, LocalFailure, MessageRejectedException {
        this.validateMessage(replyTo, "fipa-query", 13);
        return this.createAssertionalMessage(sender, intendedReceiver, dataset, defaultLanguage, replyTo);
    }

    public ACLMessage failToInformOfQueryResult(AgentId sender, AgentId intendedReceiver, ACLMessage request, ErrorExplanation explanation) throws MessageNotUnderstoodException {
        this.validateMessage(request, "fipa-query", 13);
        ACLMessage message = this.createReplyTo(request, sender, intendedReceiver, 6);
        try {
            this.addExplanation(message, explanation);
        }
        catch (LocalFailure e) {
            logger.severe("failed to generate failure message: " + (Object)((Object)e));
        }
        return message;
    }

    public ACLMessage requestQueryCancellation(AgentId sender, AgentId intendedReceiver, String conversationId) {
        ACLMessage message = new ACLMessage(2);
        message.setSender(this.toAID(sender));
        message.addReceiver(this.toAID(intendedReceiver));
        message.setProtocol("fipa-query");
        message.setConversationId(conversationId);
        return message;
    }

    public ACLMessage confirmQueryCancellation(AgentId sender, AgentId intendedReceiver, ACLMessage request) throws MessageRejectedException, MessageNotUnderstoodException {
        this.validateMessage(request, "fipa-query", 2);
        return this.createReplyTo(request, sender, intendedReceiver, 4);
    }

    public ACLMessage failToCancelQuery(AgentId sender, AgentId intendedReceiver, ACLMessage request, ErrorExplanation explanation) throws MessageNotUnderstoodException {
        this.validateMessage(request, "fipa-query", 2);
        ACLMessage message = this.createReplyTo(request, sender, intendedReceiver, 6);
        try {
            this.addExplanation(message, explanation);
        }
        catch (LocalFailure e) {
            logger.severe("failed to generate failure message: " + (Object)((Object)e));
        }
        return message;
    }

    public ACLMessage requestSubscription(AgentId sender, AgentId intendedReceiver, Value subject, RDFContentLanguage ... acceptLanguages) throws LocalFailure {
        return this.requestForInfo(sender, intendedReceiver, subject, "fipa-subscribe", 19, acceptLanguages);
    }

    public ACLMessage refuseSubscriptionRequest(AgentId sender, AgentId intendedReceiver, ACLMessage replyTo, ErrorExplanation explanation) throws MessageNotUnderstoodException, LocalFailure {
        this.validateMessage(replyTo, "fipa-subscribe", 19);
        ACLMessage message = this.createReplyTo(replyTo, sender, intendedReceiver, 14);
        this.addExplanation(message, explanation);
        return message;
    }

    public ACLMessage agreeToSubcriptionRequest(AgentId sender, AgentId intendedReceiver, ACLMessage replyTo) throws MessageRejectedException, MessageNotUnderstoodException {
        this.validateMessage(replyTo, "fipa-subscribe", 19);
        return this.createReplyTo(replyTo, sender, intendedReceiver, 1);
    }

    public ACLMessage informOfSubscriptionUpdate(AgentId sender, AgentId intendedReceiver, ACLMessage replyTo, Dataset dataset, RDFContentLanguage defaultLanguage) throws MessageRejectedException, MessageNotUnderstoodException, LocalFailure {
        this.validateMessage(replyTo, "fipa-subscribe", 19);
        return this.createAssertionalMessage(sender, intendedReceiver, dataset, defaultLanguage, replyTo);
    }

    public ACLMessage failToInformOfSubscriptionUpdate(AgentId sender, AgentId intendedReceiver, ACLMessage request, ErrorExplanation explanation) throws MessageNotUnderstoodException {
        this.validateMessage(request, "fipa-subscribe", 19);
        ACLMessage message = this.createReplyTo(request, sender, intendedReceiver, 6);
        try {
            this.addExplanation(message, explanation);
        }
        catch (LocalFailure e) {
            logger.severe("failed to generate failure message: " + (Object)((Object)e));
        }
        return message;
    }

    public ACLMessage requestSubscriptionCancellation(AgentId sender, AgentId intendedReceiver, String conversationId) {
        ACLMessage message = new ACLMessage(2);
        message.setSender(this.toAID(sender));
        message.addReceiver(this.toAID(intendedReceiver));
        message.setProtocol("fipa-subscribe");
        message.setConversationId(conversationId);
        return message;
    }

    public ACLMessage confirmSubscriptionCancellation(AgentId sender, AgentId intendedReceiver, ACLMessage request) throws MessageRejectedException, MessageNotUnderstoodException {
        this.validateMessage(request, "fipa-subscribe", 2);
        return this.createReplyTo(request, sender, intendedReceiver, 4);
    }

    public ACLMessage failToCancelSubscription(AgentId sender, AgentId intendedReceiver, ACLMessage request, ErrorExplanation explanation) throws MessageNotUnderstoodException {
        this.validateMessage(request, "fipa-subscribe", 2);
        ACLMessage message = this.createReplyTo(request, sender, intendedReceiver, 6);
        try {
            this.addExplanation(message, explanation);
        }
        catch (LocalFailure e) {
            logger.severe("failed to generate failure message: " + (Object)((Object)e));
        }
        return message;
    }

    private Resource toResource(AbsTerm term, ACLMessage message) throws MessageNotUnderstoodException {
        String iri = term.getAbsObject("iri").toString();
        if (!this.isValidIRI(iri)) {
            throw new MessageNotUnderstoodException("invalid IRI reference '" + iri + "' in query: " + message.getContent());
        }
        try {
            return this.valueFactory.createIRI(iri);
        }
        catch (IllegalArgumentException e) {
            throw new MessageNotUnderstoodException("illegal IRI in query: " + message.getContent());
        }
    }

    private Literal toLiteral(AbsTerm term, ACLMessage message) throws MessageNotUnderstoodException {
        String label = term.getAbsObject("label").toString();
        AbsObject languageObj = term.getAbsObject("language");
        AbsObject datatypeObj = term.getAbsObject("datatype");
        try {
            if (null != languageObj) {
                String lang = languageObj.toString();
                return this.valueFactory.createLiteral(label, lang);
            }
            if (null != datatypeObj) {
                String iri = datatypeObj.getAbsObject("iri").toString();
                if (!this.isValidIRI(iri)) {
                    throw new MessageNotUnderstoodException("invalid datatype IRI '" + iri + "' in query: " + message.getContent());
                }
                return this.valueFactory.createLiteral(label, this.valueFactory.createIRI(iri));
            }
            return this.valueFactory.createLiteral(label);
        }
        catch (IllegalArgumentException e) {
            throw new MessageNotUnderstoodException("illegal literal value in query: " + message.getContent());
        }
    }

    private AbsContentElement extractAbsContent(ACLMessage message) throws MessageNotUnderstoodException, LocalFailure {
        this.assertSLContent(message);
        this.assertRDFAgentsProtocolWithConvoId(message);
        try {
            return this.contentManager.extractAbsContent(message);
        }
        catch (Codec.CodecException e) {
            throw new LocalFailure((Throwable)e);
        }
        catch (OntologyException e) {
            throw new MessageNotUnderstoodException(e.getMessage());
        }
    }

    private String getContentLanguage(ACLMessage message) throws MessageNotUnderstoodException {
        this.assertHasContent(message);
        String l = message.getLanguage();
        if (null == l) {
            throw new MessageNotUnderstoodException("missing content language for message");
        }
        return l;
    }

    private RDFContentLanguage getRDFContentLanguage(ACLMessage message) throws MessageNotUnderstoodException {
        String l = this.getContentLanguage(message);
        RDFContentLanguage language = RDFContentLanguage.getByName((String)l);
        if (null == language) {
            throw new MessageNotUnderstoodException("unknown or unsupported RDF content language: " + l);
        }
        if (message.getPerformative() != 9) {
            throw new MessageNotUnderstoodException("unexpected performative (expected 9)");
        }
        return language;
    }

    private void assertHasContent(ACLMessage message) throws MessageNotUnderstoodException {
        if (null == message.getContent() || 0 == message.getContent().length()) {
            throw new MessageNotUnderstoodException("missing content");
        }
    }

    private void assertSLContent(ACLMessage message) throws MessageNotUnderstoodException {
        String l = this.getContentLanguage(message);
        if (!l.equals("fipa-sl2")) {
            throw new MessageNotUnderstoodException("wrong content language for this type of message (found " + l + ", expected " + "fipa-sl2");
        }
        String o = message.getOntology();
        if (null == o) {
            throw new MessageNotUnderstoodException("missing ontology value (expected 'rdfagents')");
        }
        if (!o.equals("rdfagents")) {
            throw new MessageNotUnderstoodException("unexpected ontology value (expected 'rdfagents'): '" + o + "'");
        }
    }

    private void assertRDFAgentsProtocolWithConvoId(ACLMessage message) throws MessageNotUnderstoodException {
        String protocol = message.getProtocol();
        if (null == protocol) {
            throw new MessageNotUnderstoodException("missing protocol value (expecting '" + RDFAgents.Protocol.Query.getFipaName() + "' or '" + RDFAgents.Protocol.Subscribe.getFipaName() + "'");
        }
        if (null == RDFAgents.Protocol.getByName((String)protocol)) {
            throw new MessageNotUnderstoodException("unexpected protocol value (expecting '" + RDFAgents.Protocol.Query.getFipaName() + "' or '" + RDFAgents.Protocol.Subscribe.getFipaName() + "': " + protocol);
        }
        if (null == message.getConversationId()) {
            throw new MessageNotUnderstoodException("missing conversation id");
        }
    }

    private void addExplanation(ACLMessage message, ErrorExplanation ex) throws LocalFailure {
        message.setLanguage(this.sl2Codec.getName());
        message.setOntology(this.rdfAgentsOntology.getName());
        try {
            AbsPredicate exp = new AbsPredicate(ex.getType().getFipaName());
            exp.set("message", ex.getMessage());
            this.contentManager.fillContent(message, (AbsContentElement)exp);
        }
        catch (Codec.CodecException | OntologyException e) {
            throw new LocalFailure(e);
        }
    }

    private boolean isValidIRI(String iri) {
        try {
            this.valueFactory.createIRI(iri);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private ACLMessage createReplyTo(ACLMessage replyTo, AgentId sender, AgentId intendedReceiver, int performative) {
        ACLMessage message = new ACLMessage(performative);
        message.setSender(this.toAID(sender));
        message.addReceiver(replyTo.getSender());
        message.setProtocol(replyTo.getProtocol());
        message.setConversationId(replyTo.getConversationId());
        return message;
    }

    private void validateMessage(ACLMessage message, String protocol, int performative) throws MessageNotUnderstoodException {
        if (null == message.getConversationId()) {
            throw new MessageNotUnderstoodException("missing conversation ID");
        }
        if (null == message.getProtocol() || 0 == message.getProtocol().length()) {
            throw new MessageNotUnderstoodException("missing protocol");
        }
        if (!message.getProtocol().equals(protocol)) {
            throw new MessageNotUnderstoodException("unexpected protocol: " + message.getProtocol());
        }
        if (performative != message.getPerformative()) {
            throw new MessageNotUnderstoodException("unexpected performative (code): " + performative);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ACLMessage createAssertionalMessage(AgentId sender, AgentId intendedReceiver, Dataset dataset, RDFContentLanguage defaultLanguage, ACLMessage replyTo) throws MessageNotUnderstoodException, LocalFailure, MessageRejectedException {
        ACLMessage message = this.createReplyTo(replyTo, sender, intendedReceiver, 9);
        RDFContentLanguage language = this.chooseRDFContentLanguage(replyTo, defaultLanguage);
        message.setLanguage(language.getFipaName());
        Dataset safe = this.datasetFactory.renameGraphs(dataset);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.datasetFactory.write((OutputStream)out, safe, language);
            message.setContent(out.toString());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new LocalFailure("internal I/O error while writing RDF content entity: " + e.getMessage());
            }
        }
        return message;
    }

    private RDFContentLanguage chooseRDFContentLanguage(ACLMessage request, RDFContentLanguage defaultLanguage) throws MessageNotUnderstoodException, MessageRejectedException {
        String langs = request.getUserDefinedParameter("X-rdfagents-accept");
        if (null == langs) {
            return defaultLanguage;
        }
        for (String l : langs.split("[;]")) {
            if (0 == (l = l.trim()).length()) {
                throw new MessageNotUnderstoodException("invalid 'X-rdfagents-accept' value: " + langs);
            }
            RDFContentLanguage g = RDFContentLanguage.getByName((String)l);
            if (null == g) {
                throw new MessageNotUnderstoodException("unknown RDF content language: " + l);
            }
            if (!this.datasetFactory.getSupportedLanguages().contains(g)) continue;
            return g;
        }
        throw new MessageRejectedException(new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "specified RDF content languages are not supported: " + langs));
    }

    private AbsConcept valueToConcept(Value value) {
        if (value instanceof IRI) {
            return this.iriToConcept((IRI)value);
        }
        if (value instanceof Literal) {
            return this.literalToConcept((Literal)value);
        }
        throw new IllegalArgumentException("resource is of an unexpected class: " + value);
    }

    private AbsConcept iriToConcept(IRI value) {
        AbsConcept c = new AbsConcept("resource");
        c.set("iri", value.stringValue());
        return c;
    }

    private AbsConcept literalToConcept(Literal value) {
        AbsConcept c = new AbsConcept("literal");
        c.set("label", value.getLabel());
        if (value.getLanguage().isPresent()) {
            c.set("language", (String)value.getLanguage().get());
        }
        if (null != value.getDatatype()) {
            c.set("datatype", (AbsTerm)this.iriToConcept(value.getDatatype()));
        }
        return c;
    }

    private ACLMessage requestForInfo(AgentId sender, AgentId intendedReceiver, Value subject, String protocol, int performative, RDFContentLanguage ... acceptLanguages) throws LocalFailure {
        ACLMessage message = new ACLMessage(performative);
        message.setSender(this.toAID(sender));
        message.addReceiver(this.toAID(intendedReceiver));
        message.setProtocol(protocol);
        message.setConversationId(this.createConversationId());
        message.setLanguage(this.sl2Codec.getName());
        message.setOntology(this.rdfAgentsOntology.getName());
        if (0 < acceptLanguages.length) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (RDFContentLanguage l : acceptLanguages) {
                if (first) {
                    first = false;
                } else {
                    sb.append("; ");
                }
                sb.append(l.getFipaName());
            }
            message.addUserDefinedParameter("X-rdfagents-accept", sb.toString());
        }
        try {
            AbsConcept s = this.valueToConcept(subject);
            AbsPredicate describes = new AbsPredicate("describes");
            AbsVariable d = new AbsVariable("dataset", "value");
            describes.set("dataset", (AbsObject)d);
            describes.set("subject", (AbsObject)s);
            AbsIRE any = new AbsIRE("any");
            any.setVariable(d);
            any.setProposition(describes);
            this.contentManager.fillContent(message, (AbsContentElement)any);
        }
        catch (Codec.CodecException | OntologyException e) {
            throw new LocalFailure(e);
        }
        return message;
    }

    private String createConversationId() {
        byte[] bytes = new byte[32];
        for (int i = 0; i < 32; ++i) {
            int c = this.random.nextInt(16);
            bytes[i] = (byte)(c > 9 ? c - 10 + 97 : c + 48);
        }
        return new String(bytes);
    }

    public AID toAID(AgentId ref) {
        AID a = new AID();
        a.setName(ref.getName());
        for (IRI u : ref.getTransportAddresses()) {
            a.addAddresses(u.toString());
        }
        return a;
    }

    public AgentId fromAID(AID s) throws MessageNotUnderstoodException {
        if (null == s.getName()) {
            throw new MessageNotUnderstoodException("missing agent name in message");
        }
        if (!RDFAgents.isValidIRI((String)s.getName())) {
            throw new MessageNotUnderstoodException("agent name is not a legal IRI: " + s.getName());
        }
        IRI name = this.valueFactory.createIRI(s.getName());
        LinkedList<IRI> addresses = new LinkedList<IRI>();
        for (String address : s.getAddressesArray()) {
            if (null == address) {
                throw new MessageNotUnderstoodException("null sender's transport address in message");
            }
            if (!RDFAgents.isValidIRI((String)address)) {
                logger.info("sender's address could not be converted to an IRI: " + address);
                continue;
            }
            addresses.add(this.valueFactory.createIRI(address));
        }
        IRI[] iris = new IRI[addresses.size()];
        int i = 0;
        for (IRI u : addresses) {
            iris[i++] = u;
        }
        return new AgentId(name, iris);
    }
}

