/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents;

import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import net.fortytwo.rdfagents.RDFAgents;
import net.fortytwo.rdfagents.data.DatasetFactory;
import net.fortytwo.rdfagents.jade.MessageFactory;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.RDFContentLanguage;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public abstract class RDFAgentsTestCase
extends TestCase {
    protected AgentId sender;
    protected AgentId receiver;
    protected IRI resourceX = RDFAgents.createIRI((String)"http://example.org/resourceX");
    protected Literal plainLiteralX = new LiteralImpl("Don't panic.");
    protected Literal typedLiteralX = new LiteralImpl("Don't panic.", (URI)XMLSchema.STRING);
    protected Literal languageLiteralX = new LiteralImpl("Don't panic.", "en");
    protected static final String NS = "http://example.org/ns#";
    protected static final IRI ARTHUR = RDFAgents.createIRI((String)"http://example.org/ns#arthur");
    protected Sail sail;
    protected DatasetFactory datasetFactory;
    protected MessageFactory messageFactory;

    public void setUp() throws Exception {
        Dataset d;
        IRI senderName = RDFAgents.createIRI((String)"http://example.org/agentA");
        IRI[] senderAddresses = new IRI[]{RDFAgents.createIRI((String)"mailto:agentA@example.org"), RDFAgents.createIRI((String)"xmpp:agentA@example.org")};
        this.sender = new AgentId(senderName, senderAddresses);
        IRI receiverName = RDFAgents.createIRI((String)"http://example.org/agentB");
        IRI[] receiverAddresses = new IRI[]{RDFAgents.createIRI((String)"mailto:agentB@example.org"), RDFAgents.createIRI((String)"xmpp:agentB@example.org")};
        this.receiver = new AgentId(receiverName, receiverAddresses);
        this.datasetFactory = new DatasetFactory((ValueFactory)new ValueFactoryImpl());
        for (RDFContentLanguage l : RDFContentLanguage.values()) {
            this.datasetFactory.addLanguage(l);
        }
        try (InputStream in = RDFAgents.class.getResourceAsStream("dummyData.trig");){
            d = this.datasetFactory.parse(in, RDFContentLanguage.RDF_TRIG);
        }
        this.sail = new MemoryStore();
        this.sail.initialize();
        this.datasetFactory.addToSail(d, this.sail);
        this.messageFactory = new MessageFactory(this.datasetFactory);
    }

    public void tearDown() throws Exception {
        this.sail.shutDown();
    }

    protected void showDataset(Dataset d) throws Exception {
        RDFWriter w = Rio.createWriter((RDFFormat)RDFFormat.TRIG, (OutputStream)System.out);
        w.startRDF();
        d.getStatements().forEach(arg_0 -> ((RDFWriter)w).handleStatement(arg_0));
        w.endRDF();
    }
}

