/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade.testing;

import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.BasicOntology;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.StringACLCodec;
import java.util.Random;
import net.fortytwo.rdfagents.jade.RDFAgentsOntology;

public class ExampleMessages {
    private static final String EXAMPLE_RDF = "@prefix dbpprop: <http://dbpedia.org/property/> .\n@prefix dbpedia-owl: <http://dbpedia.org/ontology/> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n\n<http://dbpedia.org/resource/Beijing>\n    dbpprop:name \"Beijing\"@en ;\n    dbpedia-owl:country <http://dbpedia.org/resource/China> ;\n    owl:sameAs\n        <http://data.nytimes.com/49823253852479839961>,\n\t<http://dbpedia.org/resource/Beijing>,\n\t<http://rdf.freebase.com/ns/m/01914>,\n\t<http://rdf.freebase.com/ns/m/047txg>,\n\t<http://sws.geonames.org/1816670/> ;\n    [...]";
    private static final String EXAMPLE_DESCRIBE_QUERY = "(describe (uri http://dbpedia.org/resource/Beijing) :language rdf-trig)";

    public static void main(String[] args) throws Exception {
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            int n = r.nextInt(16);
            if (n < 10) {
                sb.append(n);
                continue;
            }
            sb.append((char)(65 + n - 10));
        }
        String convId = sb.toString();
        AID client = new AID();
        client.setName("http://fortytwo.net/agents/smith");
        client.addAddresses("xmpp:smith@fortytwo.net");
        AID server = new AID();
        server.setName("http://example.org/rdfnews");
        server.addAddresses("xmpp:rdfnews@example.org");
        ContentManager manager = new ContentManager();
        SLCodec codec = new SLCodec(0);
        manager.registerLanguage((Codec)codec);
        manager.registerOntology(BasicOntology.getInstance());
        for (String s : manager.getLanguageNames()) {
            System.out.println("language: " + s);
        }
        for (String s : manager.getOntologyNames()) {
            System.out.println("ontology: " + s);
        }
        ACLMessage m = new ACLMessage(7);
        m.setSender(client);
        m.addReceiver(server);
        ExampleMessages.print(m);
        m = new ACLMessage(13);
        m.setSender(client);
        m.addReceiver(server);
        m.setProtocol("fipa-query");
        m.setConversationId(convId);
        m.setLanguage(codec.getName());
        m.setOntology(RDFAgentsOntology.getInstance().getName());
        m.setContent("(describe (uri \"http://dbpedia.org/resource/Beijing\"))");
        ExampleMessages.print(m);
        m = new ACLMessage(9);
        m.setSender(server);
        m.addReceiver(client);
        m.setLanguage("rdf-nquads");
        m.setConversationId(convId);
        m.setProtocol("fipa-query");
        m.setContent(EXAMPLE_RDF);
        ExampleMessages.print(m);
        m = new ACLMessage(19);
        m.setSender(client);
        m.addReceiver(server);
        m.setProtocol("fipa-subscribe");
        m.setConversationId(convId);
        m.setLanguage(codec.getName());
        m.setOntology(RDFAgentsOntology.getInstance().getName());
        m.setContent(EXAMPLE_DESCRIBE_QUERY);
        ExampleMessages.print(m);
        m = new ACLMessage(1);
        m.setSender(server);
        m.addReceiver(client);
        m.setProtocol("fipa-subscribe");
        m.setConversationId(convId);
        ExampleMessages.print(m);
    }

    private static void print(ACLMessage m) {
        StringACLCodec c = new StringACLCodec();
        byte[] bytes = c.encode(m, "UTF-8");
        System.out.println(new String(bytes));
    }
}

