/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import net.fortytwo.rdfagents.data.DatasetQuery;
import net.fortytwo.rdfagents.data.RecursiveDescribeQuery;
import net.fortytwo.rdfagents.messaging.Commitment;
import net.fortytwo.rdfagents.messaging.LocalFailure;
import net.fortytwo.rdfagents.messaging.query.QueryProvider;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.RDFAgent;
import org.openrdf.model.Value;
import org.openrdf.sail.Sail;

public class SailBasedQueryProvider
extends QueryProvider<Value, Dataset> {
    private final Sail sail;

    public SailBasedQueryProvider(RDFAgent agent, Sail sail) {
        super(agent);
        this.sail = sail;
    }

    public Commitment considerQueryRequest(String conversationId, Value query, AgentId initiator) {
        return new Commitment(Commitment.Decision.AGREE_SILENTLY, null);
    }

    public Dataset answer(Value query) throws LocalFailure {
        System.out.println("### got a query: " + query);
        try {
            Dataset result = new RecursiveDescribeQuery(query, this.sail).evaluate();
            System.out.println("###### " + result.getStatements().size() + " statements in result");
            return result;
        }
        catch (DatasetQuery.DatasetQueryException e) {
            throw new LocalFailure((Throwable)e);
        }
    }

    public void cancel(String conversationId) throws LocalFailure {
    }
}

