/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.fortytwo.rdfagents.RDFAgents;
import net.fortytwo.rdfagents.jade.MessageFactory;
import net.fortytwo.rdfagents.jade.RDFAgentsPlatformImpl;
import net.fortytwo.rdfagents.messaging.CancellationCallback;
import net.fortytwo.rdfagents.messaging.Commitment;
import net.fortytwo.rdfagents.messaging.ConsumerCallback;
import net.fortytwo.rdfagents.messaging.LocalFailure;
import net.fortytwo.rdfagents.messaging.MessageNotUnderstoodException;
import net.fortytwo.rdfagents.messaging.MessageRejectedException;
import net.fortytwo.rdfagents.messaging.query.QueryProvider;
import net.fortytwo.rdfagents.messaging.subscribe.PubsubProvider;
import net.fortytwo.rdfagents.messaging.subscribe.UpdateHandler;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.ErrorExplanation;
import net.fortytwo.rdfagents.model.RDFContentLanguage;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class RDFJadeAgent
extends Agent {
    private static final Logger LOGGER = Logger.getLogger(RDFJadeAgent.class.getName());
    private final Map<String, ConsumerCallback<Dataset>> queryCallbacks = new HashMap<String, ConsumerCallback<Dataset>>();
    private final Map<String, CancellationCallback> queryCancellationCallbacks = new HashMap<String, CancellationCallback>();
    private final Map<String, ConsumerCallback<Dataset>> subscriptionCallbacks = new HashMap<String, ConsumerCallback<Dataset>>();
    private final Map<String, CancellationCallback> subscriptionCancellationCallbacks = new HashMap<String, CancellationCallback>();
    private AgentId self;
    private MessageFactory messageFactory;
    private QueryProvider<Value, Dataset> queryProvider;
    private PubsubProvider<Value, Dataset> pubsubProvider;

    public Task submitQuery(final Value resource, final AgentId server, final ConsumerCallback<Dataset> callback) {
        return new Task(){

            @Override
            public void execute() {
                String conversationId = null;
                try {
                    ACLMessage m = RDFJadeAgent.this.messageFactory.poseQuery(RDFJadeAgent.this.self, server, resource, new RDFContentLanguage[0]);
                    conversationId = m.getConversationId();
                    this.setConversationId(conversationId);
                    System.out.println("issuing a query for " + resource);
                    RDFJadeAgent.this.queryCallbacks.put(conversationId, callback);
                    RDFJadeAgent.this.sendMessage(m);
                }
                catch (LocalFailure e) {
                    RDFJadeAgent.this.forgetConversation(conversationId);
                    callback.localFailure(e);
                }
                catch (Throwable e) {
                    RDFJadeAgent.this.forgetConversation(conversationId);
                    callback.localFailure(new LocalFailure(e));
                }
            }
        };
    }

    public Task cancelQuery(final String conversationId, final AgentId server, final CancellationCallback callback) {
        return new Task(){

            @Override
            public void execute() {
                try {
                    ConsumerCallback qc = (ConsumerCallback)RDFJadeAgent.this.queryCallbacks.get(conversationId);
                    if (null == qc) {
                        LOGGER.info("attempted to cancel Query conversation " + conversationId + ", which has already concluded or does not exist");
                    } else {
                        RDFJadeAgent.this.queryCallbacks.remove(conversationId);
                        ACLMessage m = RDFJadeAgent.this.messageFactory.requestQueryCancellation(RDFJadeAgent.this.self, server, conversationId);
                        this.setConversationId(m.getConversationId());
                        RDFJadeAgent.this.queryCancellationCallbacks.put(m.getConversationId(), callback);
                        RDFJadeAgent.this.sendMessage(m);
                    }
                }
                catch (Throwable e) {
                    RDFJadeAgent.this.forgetConversation(conversationId);
                    callback.localFailure(new LocalFailure(e));
                }
            }
        };
    }

    public Task subscribe(final Value topic, final AgentId publisher, final ConsumerCallback<Dataset> callback) {
        return new Task(){

            @Override
            public void execute() {
                String conversationId = null;
                try {
                    ACLMessage m = RDFJadeAgent.this.messageFactory.requestSubscription(RDFJadeAgent.this.self, publisher, topic, new RDFContentLanguage[0]);
                    conversationId = m.getConversationId();
                    this.setConversationId(conversationId);
                    System.out.println("issuing a subscription request for " + topic);
                    RDFJadeAgent.this.subscriptionCallbacks.put(conversationId, callback);
                    RDFJadeAgent.this.sendMessage(m);
                }
                catch (LocalFailure e) {
                    RDFJadeAgent.this.forgetConversation(conversationId);
                    callback.localFailure(e);
                }
                catch (Throwable e) {
                    RDFJadeAgent.this.forgetConversation(conversationId);
                    callback.localFailure(new LocalFailure(e));
                }
            }
        };
    }

    public Task cancelSubscription(final String conversationId, final AgentId server, final CancellationCallback callback) {
        return new Task(){

            @Override
            public void execute() {
                try {
                    ConsumerCallback qc = (ConsumerCallback)RDFJadeAgent.this.subscriptionCallbacks.get(conversationId);
                    if (null == qc) {
                        LOGGER.info("attempted to cancel Subscribe conversation " + conversationId + ", which has already concluded or does not exist");
                    } else {
                        RDFJadeAgent.this.subscriptionCallbacks.remove(conversationId);
                        ACLMessage m = RDFJadeAgent.this.messageFactory.requestSubscriptionCancellation(RDFJadeAgent.this.self, server, conversationId);
                        this.setConversationId(m.getConversationId());
                        RDFJadeAgent.this.subscriptionCancellationCallbacks.put(m.getConversationId(), callback);
                        RDFJadeAgent.this.sendMessage(m);
                    }
                }
                catch (Throwable e) {
                    RDFJadeAgent.this.forgetConversation(conversationId);
                    callback.localFailure(new LocalFailure(e));
                }
            }
        };
    }

    public void setQueryProvider(QueryProvider<Value, Dataset> queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setPubsubProvider(PubsubProvider<Value, Dataset> pubsubProvider) {
        this.pubsubProvider = pubsubProvider;
    }

    public void setup() {
        this.setEnabledO2ACommunication(true, 10);
        Object[] args = this.getArguments();
        if (args.length != 2) {
            throw new IllegalStateException();
        }
        Wrapper w = (Wrapper)args[1];
        w.setJadeAgent(this);
        this.messageFactory = w.messageFactory;
        this.self = w.self;
        RDFAgentsPlatformImpl.CondVar latch = (RDFAgentsPlatformImpl.CondVar)args[0];
        latch.signal();
        this.addBehaviour((Behaviour)new CyclicBehaviour(){

            public void action() {
                ACLMessage m = this.myAgent.receive();
                if (null != m) {
                    RDFJadeAgent.this.receiveMessage(m);
                    try {
                        RDFJadeAgent.this.handleMessage(m);
                    }
                    catch (Throwable t) {
                        RDFJadeAgent.this.forgetConversation(m.getConversationId());
                        LOGGER.severe("error while sending message: " + t + "\n" + RDFAgents.stackTraceToString((Throwable)t));
                    }
                } else {
                    this.block();
                }
            }
        });
        this.addBehaviour((Behaviour)new CyclicBehaviour(){

            public void action() {
                Object obj = RDFJadeAgent.this.getO2AObject();
                if (obj != null) {
                    System.out.println("Got an object from the queue: [" + obj + "]");
                    if (obj instanceof Task) {
                        ((Task)obj).execute();
                    }
                } else {
                    this.block();
                }
            }
        });
        StringBuilder sb = new StringBuilder("initialized agent <").append(this.self.getUri()).append("> with address(es) ");
        boolean first = true;
        for (URI s : this.self.getTransportAddresses()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("<").append(s).append(">");
        }
        System.out.println(sb.toString());
    }

    private void forgetConversation(String id) {
        if (null != id) {
            this.queryCallbacks.remove(id);
            this.queryCancellationCallbacks.remove(id);
            this.subscriptionCallbacks.remove(id);
            this.subscriptionCancellationCallbacks.remove(id);
            try {
                if (null != this.queryProvider) {
                    this.queryProvider.cancel(id);
                }
                if (null != this.pubsubProvider) {
                    this.pubsubProvider.cancel(id);
                }
            }
            catch (LocalFailure e) {
                LOGGER.severe("failed to cancel expired conversations (stack trace follows)\n" + RDFAgents.stackTraceToString((Throwable)e));
            }
        }
    }

    public void takeDown() {
        this.setEnabledO2ACommunication(false, 0);
    }

    private void handleMessage(ACLMessage m) {
        block30: {
            if (6 == m.getPerformative()) {
                this.handleFailure(m);
            } else if (10 == m.getPerformative()) {
                this.handleNotUnderstood(m);
            } else {
                AgentId sender;
                try {
                    sender = this.messageFactory.fromAID(m.getSender());
                }
                catch (MessageNotUnderstoodException e) {
                    LOGGER.warning("message is invalid, cannot reply: " + e.getMessage());
                    return;
                }
                try {
                    if (null == m.getConversationId()) {
                        throw new MessageNotUnderstoodException("missing conversation ID");
                    }
                    int performative = m.getPerformative();
                    String protocol = m.getProtocol();
                    if (null == protocol || 0 == protocol.length()) {
                        throw new MessageNotUnderstoodException("missing protocol");
                    }
                    if (protocol.equals("fipa-query")) {
                        switch (performative) {
                            case 13: {
                                this.handleQueryRequest(m, sender);
                                break block30;
                            }
                            case 9: {
                                this.handleQueryResult(m);
                                break block30;
                            }
                            case 14: {
                                this.handleQueryRefused(m);
                                break block30;
                            }
                            case 1: {
                                this.handleQueryAccepted(m);
                                break block30;
                            }
                            case 2: {
                                this.handleCancelQuery(m, sender);
                                break block30;
                            }
                            case 4: {
                                this.handleQueryCancellationConfirmed(m);
                                break block30;
                            }
                            default: {
                                throw new MessageNotUnderstoodException("unexpected performative (code): " + performative);
                            }
                        }
                    }
                    if (protocol.equals("fipa-subscribe")) {
                        switch (performative) {
                            case 19: {
                                this.handleSubscriptionRequest(m, sender);
                                break block30;
                            }
                            case 9: {
                                this.handleUpdate(m);
                                break block30;
                            }
                            case 14: {
                                this.handleSubscriptionRefused(m);
                                break block30;
                            }
                            case 1: {
                                this.handleSubscriptionAccepted(m);
                                break block30;
                            }
                            case 2: {
                                this.handleCancelSubscription(m, sender);
                                break block30;
                            }
                            case 4: {
                                this.handleSubscriptionCancellationConfirmed(m);
                                break block30;
                            }
                            default: {
                                throw new MessageNotUnderstoodException("unexpected performative (code): " + performative);
                            }
                        }
                    }
                    throw new MessageNotUnderstoodException("unexpected protocol: " + protocol);
                }
                catch (MessageNotUnderstoodException e) {
                    ErrorExplanation exp = new ErrorExplanation(ErrorExplanation.Type.ExternalError, e.getMessage());
                    this.sendMessage(this.messageFactory.notUnderstood(m, this.self, sender, exp));
                    this.forgetConversation(m.getConversationId());
                }
                catch (MessageRejectedException e) {
                    this.sendMessage(this.messageFactory.failure(this.self, sender, m, e.getExplanation()));
                    this.forgetConversation(m.getConversationId());
                }
                catch (LocalFailure e) {
                    ErrorExplanation exp = new ErrorExplanation(ErrorExplanation.Type.InternalError, e.getMessage());
                    this.sendMessage(this.messageFactory.notUnderstood(m, this.self, sender, exp));
                    this.forgetConversation(m.getConversationId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailure(ACLMessage m) {
        ConsumerCallback<Dataset> qc = this.queryCallbacks.get(m.getConversationId());
        CancellationCallback cc = this.queryCancellationCallbacks.get(m.getConversationId());
        try {
            try {
                ErrorExplanation exp = this.messageFactory.extractErrorExplanation(m);
                if (null != qc) {
                    qc.remoteFailure(exp);
                }
                if (null != cc) {
                    cc.remoteFailure(exp);
                }
            }
            catch (MessageNotUnderstoodException e) {
                LOGGER.warning("failure message not understood: " + e.getMessage());
            }
            catch (LocalFailure e) {
                if (null != qc) {
                    qc.localFailure(e);
                }
                if (null != cc) {
                    cc.localFailure(e);
                }
            }
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotUnderstood(ACLMessage m) {
        try {
            LOGGER.warning("received a not-understood message: " + m);
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    private void handleQueryRequest(ACLMessage m, AgentId sender) throws MessageNotUnderstoodException, LocalFailure, MessageRejectedException {
        this.assertRDFAgentsOntologyContent(m);
        if (null == this.queryProvider) {
            throw new MessageRejectedException(new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "this agent does not implement the query server role"));
        }
        Value v = this.messageFactory.extractDescribeQuery(m);
        Commitment c = this.queryProvider.considerQueryRequest(m.getConversationId(), (Object)v, sender);
        switch (c.getDecision()) {
            case AGREE_AND_NOTIFY: {
                this.sendMessage(this.messageFactory.agreeToAnswerQuery(this.self, sender, m));
                this.sendMessage(this.messageFactory.informOfQueryResult(this.self, sender, m, (Dataset)this.queryProvider.answer((Object)v), RDFContentLanguage.RDF_NQUADS));
                break;
            }
            case AGREE_SILENTLY: {
                this.sendMessage(this.messageFactory.informOfQueryResult(this.self, sender, m, (Dataset)this.queryProvider.answer((Object)v), RDFContentLanguage.RDF_NQUADS));
                break;
            }
            case REFUSE: {
                this.sendMessage(this.messageFactory.refuseToAnswerQuery(this.self, sender, m, c.getExplanation()));
                break;
            }
            default: {
                throw new LocalFailure("unexpected decision: " + c.getDecision());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryResult(ACLMessage m) throws MessageRejectedException, MessageNotUnderstoodException, LocalFailure {
        ConsumerCallback<Dataset> callback = this.getQueryCallback(m);
        try {
            Dataset answer = this.messageFactory.extractDataset(m);
            callback.success((Object)answer);
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    private void handleUpdate(ACLMessage m) throws MessageRejectedException, MessageNotUnderstoodException, LocalFailure {
        ConsumerCallback<Dataset> callback = this.getSubscriptionCallback(m);
        Dataset answer = this.messageFactory.extractDataset(m);
        callback.success((Object)answer);
    }

    private void handleQueryAccepted(ACLMessage m) throws MessageRejectedException {
        this.getQueryCallback(m).agreed();
    }

    private void handleSubscriptionAccepted(ACLMessage m) throws MessageRejectedException {
        this.getSubscriptionCallback(m).agreed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryRefused(ACLMessage m) throws MessageNotUnderstoodException, LocalFailure, MessageRejectedException {
        try {
            ErrorExplanation exp = this.messageFactory.extractErrorExplanation(m);
            this.getQueryCallback(m).refused(exp);
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscriptionRefused(ACLMessage m) throws MessageNotUnderstoodException, LocalFailure, MessageRejectedException {
        try {
            ErrorExplanation exp = this.messageFactory.extractErrorExplanation(m);
            this.getSubscriptionCallback(m).refused(exp);
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancelQuery(ACLMessage m, AgentId sender) throws MessageNotUnderstoodException {
        try {
            ErrorExplanation exp = new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "cancellation of queries is not yet supported");
            this.sendMessage(this.messageFactory.failToCancelQuery(this.self, sender, m, exp));
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancelSubscription(ACLMessage m, AgentId sender) throws MessageNotUnderstoodException {
        try {
            ErrorExplanation exp = new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "cancellation of subscriptions is not yet supported");
            this.sendMessage(this.messageFactory.failToCancelSubscription(this.self, sender, m, exp));
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryCancellationConfirmed(ACLMessage m) throws MessageRejectedException {
        try {
            this.getQueryCancellationCallback(m, true).success();
            this.removeQueryCancellationCallback(m);
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscriptionCancellationConfirmed(ACLMessage m) throws MessageRejectedException {
        try {
            this.getQueryCancellationCallback(m, false).success();
            this.removeQueryCancellationCallback(m);
        }
        finally {
            this.forgetConversation(m.getConversationId());
        }
    }

    private void handleSubscriptionRequest(final ACLMessage m, final AgentId sender) throws MessageNotUnderstoodException, LocalFailure, MessageRejectedException {
        this.assertRDFAgentsOntologyContent(m);
        if (null == this.pubsubProvider) {
            throw new MessageRejectedException(new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "this agent does not implement the publisher role"));
        }
        Value v = this.messageFactory.extractDescribeQuery(m);
        UpdateHandler<Dataset> handler = new UpdateHandler<Dataset>(){

            public void handle(Dataset result) throws LocalFailure {
                try {
                    RDFJadeAgent.this.sendMessage(RDFJadeAgent.this.messageFactory.informOfSubscriptionUpdate(RDFJadeAgent.this.self, sender, m, result, RDFContentLanguage.RDF_NQUADS));
                }
                catch (MessageRejectedException e) {
                    LOGGER.severe("message rejected after update already produced (this shouldn't happen)");
                    RDFJadeAgent.this.forgetConversation(m.getConversationId());
                    RDFJadeAgent.this.pubsubProvider.cancel(m.getConversationId());
                }
                catch (MessageNotUnderstoodException e) {
                    LOGGER.severe("message not understood after update already produced (this shouldn't happen)");
                    RDFJadeAgent.this.forgetConversation(m.getConversationId());
                    RDFJadeAgent.this.pubsubProvider.cancel(m.getConversationId());
                }
            }
        };
        Commitment c = this.pubsubProvider.considerSubscriptionRequest(m.getConversationId(), (Object)v, sender, (UpdateHandler)handler);
        switch (c.getDecision()) {
            case AGREE_AND_NOTIFY: {
                this.sendMessage(this.messageFactory.agreeToSubcriptionRequest(this.self, sender, m));
                break;
            }
            case REFUSE: {
                this.sendMessage(this.messageFactory.refuseSubscriptionRequest(this.self, sender, m, c.getExplanation()));
                break;
            }
            default: {
                throw new LocalFailure("unexpected decision: " + c.getDecision());
            }
        }
    }

    private ConsumerCallback<Dataset> getQueryCallback(ACLMessage m) throws MessageRejectedException {
        ConsumerCallback<Dataset> callback = this.queryCallbacks.get(m.getConversationId());
        if (null == callback) {
            throw new MessageRejectedException(new ErrorExplanation(ErrorExplanation.Type.InteractionExplired, "no such conversation: " + m.getConversationId()));
        }
        return callback;
    }

    private ConsumerCallback<Dataset> getSubscriptionCallback(ACLMessage m) throws MessageRejectedException {
        ConsumerCallback<Dataset> callback = this.subscriptionCallbacks.get(m.getConversationId());
        if (null == callback) {
            throw new MessageRejectedException(new ErrorExplanation(ErrorExplanation.Type.InteractionExplired, "no such conversation: " + m.getConversationId()));
        }
        return callback;
    }

    private CancellationCallback getQueryCancellationCallback(ACLMessage m, boolean queryVsSubscribe) throws MessageRejectedException {
        CancellationCallback callback;
        CancellationCallback cancellationCallback = callback = queryVsSubscribe ? this.queryCancellationCallbacks.get(m.getConversationId()) : this.subscriptionCancellationCallbacks.get(m.getConversationId());
        if (null == callback) {
            throw new MessageRejectedException(new ErrorExplanation(ErrorExplanation.Type.InteractionExplired, "no such conversation: " + m.getConversationId()));
        }
        return callback;
    }

    private void removeQueryCancellationCallback(ACLMessage m) {
        this.queryCancellationCallbacks.remove(m.getConversationId());
    }

    private void assertRDFAgentsOntologyContent(ACLMessage m) throws MessageNotUnderstoodException {
        String ontology = m.getOntology();
        if (null == ontology) {
            throw new MessageNotUnderstoodException("missing ontology parameter");
        }
    }

    private void receiveMessage(ACLMessage m) {
        System.out.println("### Message received ###########################################################\n" + m + "\n################################################################################");
    }

    private void sendMessage(ACLMessage m) {
        this.send(m);
        System.out.println("### Message sent ###############################################################\n" + m + "\n################################################################################");
    }

    public static class Wrapper {
        private final AgentId self;
        private final MessageFactory messageFactory;
        private RDFJadeAgent jadeAgent;

        public Wrapper(AgentId self, MessageFactory messageFactory) {
            this.self = self;
            this.messageFactory = messageFactory;
        }

        public RDFJadeAgent getJadeAgent() {
            return this.jadeAgent;
        }

        public void setJadeAgent(RDFJadeAgent jadeAgent) {
            this.jadeAgent = jadeAgent;
        }
    }

    public abstract class Task {
        private String conversationId;

        public abstract void execute();

        public String getConversationId() {
            return this.conversationId;
        }

        public void setConversationId(String id) {
            this.conversationId = id;
        }
    }
}

