/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.content.lang.sl.SLOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import java.util.UUID;
import net.fortytwo.rdfagents.model.ErrorExplanation;

public class RDFAgentsOntology
extends Ontology {
    private static final RDFAgentsOntology INSTANCE;
    public static final String DATASET = "dataset";
    public static final String DESCRIBES = "describes";
    public static final String DESCRIBES_DATASET = "dataset";
    public static final String DESCRIBES_SUBJECT = "subject";
    public static final String EXPLANATION = "explanation";
    public static final String EXPLANATION_MESSAGE = "message";
    public static final String LITERAL = "literal";
    public static final String LITERAL_DATATYPE = "datatype";
    public static final String LITERAL_LANGUAGE = "language";
    public static final String LITERAL_LABEL = "label";
    public static final String VALUE = "value";
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_URI = "uri";

    private RDFAgentsOntology() throws OntologyException {
        super("rdfagents", SLOntology.getInstance());
        this.add((ObjectSchema)new PredicateSchema(DESCRIBES));
        this.add((ObjectSchema)new ConceptSchema("dataset"));
        this.add((ObjectSchema)new ConceptSchema(VALUE));
        this.add((ObjectSchema)new ConceptSchema(RESOURCE));
        this.add((ObjectSchema)new ConceptSchema(LITERAL));
        this.add((ObjectSchema)new PredicateSchema(EXPLANATION));
        for (ErrorExplanation.Type x : ErrorExplanation.Type.values()) {
            this.add((ObjectSchema)new PredicateSchema(x.getFipaName()));
        }
        ConceptSchema dataset = (ConceptSchema)this.getSchema("dataset");
        ConceptSchema resource = (ConceptSchema)this.getSchema(VALUE);
        ConceptSchema uri = (ConceptSchema)this.getSchema(RESOURCE);
        ConceptSchema literal = (ConceptSchema)this.getSchema(LITERAL);
        uri.addSuperSchema(resource);
        uri.add(RESOURCE_URI, (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        literal.addSuperSchema(resource);
        literal.add(LITERAL_LABEL, (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")));
        literal.add(LITERAL_DATATYPE, (TermSchema)uri, 1);
        literal.add(LITERAL_LANGUAGE, (TermSchema)((PrimitiveSchema)this.getSchema("BO_String")), 1);
        PredicateSchema describes = (PredicateSchema)this.getSchema(DESCRIBES);
        describes.add("dataset", (ObjectSchema)dataset);
        describes.add(DESCRIBES_SUBJECT, (ObjectSchema)resource);
        PredicateSchema explanation = (PredicateSchema)this.getSchema(EXPLANATION);
        explanation.add(EXPLANATION_MESSAGE, this.getSchema("BO_String"));
        for (ErrorExplanation.Type x : ErrorExplanation.Type.values()) {
            PredicateSchema s = (PredicateSchema)this.getSchema(x.getFipaName());
            s.addSuperSchema(explanation);
        }
    }

    public static RDFAgentsOntology getInstance() {
        return INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("" + UUID.nameUUIDFromBytes("foo".getBytes()));
        System.out.println("" + UUID.nameUUIDFromBytes("bar".getBytes()));
        System.out.println("" + UUID.nameUUIDFromBytes("foo".getBytes()));
    }

    static {
        try {
            INSTANCE = new RDFAgentsOntology();
        }
        catch (OntologyException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

