/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.wrapper.AgentController;
import jade.wrapper.StaleProxyException;
import net.fortytwo.rdfagents.jade.MessageFactory;
import net.fortytwo.rdfagents.jade.RDFAgentsPlatformImpl;
import net.fortytwo.rdfagents.jade.RDFJadeAgent;
import net.fortytwo.rdfagents.messaging.CancellationCallback;
import net.fortytwo.rdfagents.messaging.ConsumerCallback;
import net.fortytwo.rdfagents.messaging.query.QueryProvider;
import net.fortytwo.rdfagents.messaging.subscribe.PubsubProvider;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.RDFAgent;
import net.fortytwo.rdfagents.model.RDFAgentsPlatform;
import org.openrdf.model.Value;

public class RDFAgentImpl
extends RDFAgent {
    private RDFJadeAgent jadeAgent;
    private AgentController controller;

    public RDFAgentImpl(RDFAgentsPlatform platform, AgentId id) throws RDFAgent.RDFAgentException {
        super(platform, id);
        if (!(platform instanceof RDFAgentsPlatformImpl)) {
            throw new IllegalArgumentException("expected RDFAgentsPlatform implementation " + RDFAgentsPlatformImpl.class.getName() + ", found " + platform.getClass().getName());
        }
        String n = id.getName();
        int at = n.lastIndexOf("@");
        String localName = at >= 0 ? n.substring(0, at) : n;
        MessageFactory messageFactory = new MessageFactory(platform.getDatasetFactory());
        RDFJadeAgent.Wrapper w = new RDFJadeAgent.Wrapper(this.getIdentity(), messageFactory);
        try {
            RDFAgentsPlatformImpl.CondVar startUpLatch = new RDFAgentsPlatformImpl.CondVar();
            AgentController c = ((RDFAgentsPlatformImpl)platform).getContainer().createNewAgent(localName, RDFJadeAgent.class.getName(), new Object[]{startUpLatch, w});
            c.start();
            startUpLatch.waitOn();
            this.setController(c);
        }
        catch (StaleProxyException e) {
            throw new RDFAgent.RDFAgentException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RDFAgent.RDFAgentException((Throwable)e);
        }
        if (null == w.getJadeAgent()) {
            throw new IllegalStateException("RDFJadeAgent not set");
        }
        this.setJadeAgent(w.getJadeAgent());
    }

    public void setQueryProvider(QueryProvider<Value, Dataset> queryProvider) {
        this.jadeAgent.setQueryProvider(queryProvider);
    }

    public void setPubsubProvider(PubsubProvider<Value, Dataset> pubsubProvider) {
        this.jadeAgent.setPubsubProvider(pubsubProvider);
    }

    public void setJadeAgent(RDFJadeAgent jadeAgent) {
        this.jadeAgent = jadeAgent;
    }

    public void setController(AgentController controller) {
        this.controller = controller;
    }

    public void putObject(Object obj) throws StaleProxyException {
        this.controller.putO2AObject(obj, false);
    }

    public RDFJadeAgent.Task submitQuery(Value resource, AgentId server, ConsumerCallback<Dataset> callback) {
        return this.jadeAgent.submitQuery(resource, server, callback);
    }

    public RDFJadeAgent.Task cancelQuery(String conversationId, AgentId server, CancellationCallback callback) {
        return this.jadeAgent.cancelQuery(conversationId, server, callback);
    }

    public RDFJadeAgent.Task subscribe(Value topic, AgentId publisher, ConsumerCallback<Dataset> callback) {
        return this.jadeAgent.subscribe(topic, publisher, callback);
    }

    public RDFJadeAgent.Task cancelSubscription(String conversationId, AgentId publisher, CancellationCallback callback) {
        return this.jadeAgent.cancelSubscription(conversationId, publisher, callback);
    }
}

