/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents;

import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import net.fortytwo.rdfagents.RDFAgents;
import net.fortytwo.rdfagents.data.DatasetFactory;
import net.fortytwo.rdfagents.jade.MessageFactory;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.RDFContentLanguage;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public abstract class RDFAgentsTestCase
extends TestCase {
    protected AgentId sender;
    protected AgentId receiver;
    protected URI resourceX = new URIImpl("http://example.org/resourceX");
    protected Literal plainLiteralX = new LiteralImpl("Don't panic.");
    protected Literal typedLiteralX = new LiteralImpl("Don't panic.", XMLSchema.STRING);
    protected Literal languageLiteralX = new LiteralImpl("Don't panic.", "en");
    protected static final String NS = "http://example.org/ns#";
    protected static final URI ARTHUR = new URIImpl("http://example.org/ns#arthur");
    protected Sail sail;
    protected DatasetFactory datasetFactory;
    protected MessageFactory messageFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Dataset d;
        URIImpl senderName = new URIImpl("http://example.org/agentA");
        URI[] senderAddresses = new URI[]{new URIImpl("mailto:agentA@example.org"), new URIImpl("xmpp:agentA@example.org")};
        this.sender = new AgentId((URI)senderName, senderAddresses);
        URIImpl receiverName = new URIImpl("http://example.org/agentB");
        URI[] receiverAddresses = new URI[]{new URIImpl("mailto:agentB@example.org"), new URIImpl("xmpp:agentB@example.org")};
        this.receiver = new AgentId((URI)receiverName, receiverAddresses);
        this.datasetFactory = new DatasetFactory((ValueFactory)new ValueFactoryImpl());
        for (RDFContentLanguage l : RDFContentLanguage.values()) {
            this.datasetFactory.addLanguage(l);
        }
        InputStream in = RDFAgents.class.getResourceAsStream("dummyData.trig");
        try {
            d = this.datasetFactory.parse(in, RDFContentLanguage.RDF_TRIG);
        }
        finally {
            in.close();
        }
        this.sail = new MemoryStore();
        this.sail.initialize();
        this.datasetFactory.addToSail(d, this.sail);
        this.messageFactory = new MessageFactory(this.datasetFactory);
    }

    public void tearDown() throws Exception {
        this.sail.shutDown();
    }

    protected void showDataset(Dataset d) throws Exception {
        RDFWriter w = Rio.createWriter((RDFFormat)RDFFormat.TRIG, (OutputStream)System.out);
        w.startRDF();
        for (Statement s : d.getStatements()) {
            w.handleStatement(s);
        }
        w.endRDF();
    }
}

