/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade.testing;

import java.io.OutputStream;
import net.fortytwo.rdfagents.RDFAgents;
import net.fortytwo.rdfagents.data.DatasetFactory;
import net.fortytwo.rdfagents.messaging.ConsumerCallback;
import net.fortytwo.rdfagents.messaging.LocalFailure;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.ErrorExplanation;
import net.fortytwo.rdfagents.model.RDFContentLanguage;

public class EchoCallback
implements ConsumerCallback<Dataset> {
    private final DatasetFactory datasetFactory;

    public EchoCallback(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    public void success(Dataset answer) {
        System.out.println("query result or update received:");
        try {
            this.datasetFactory.write((OutputStream)System.out, answer, RDFContentLanguage.RDF_TRIG);
        }
        catch (LocalFailure e) {
            e.printStackTrace(System.err);
        }
    }

    public void agreed() {
        System.out.println("agreed!");
    }

    public void refused(ErrorExplanation explanation) {
        System.out.println("refused!");
    }

    public void remoteFailure(ErrorExplanation explanation) {
        System.out.println("remote failure: " + explanation);
    }

    public void localFailure(LocalFailure e) {
        System.out.println("local failure: " + (Object)((Object)e) + "\n" + RDFAgents.stackTraceToString((Throwable)e));
    }
}

