/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.wrapper.StaleProxyException;
import net.fortytwo.rdfagents.jade.RDFAgentImpl;
import net.fortytwo.rdfagents.jade.RDFJadeAgent;
import net.fortytwo.rdfagents.messaging.CancellationCallback;
import net.fortytwo.rdfagents.messaging.ConsumerCallback;
import net.fortytwo.rdfagents.messaging.LocalFailure;
import net.fortytwo.rdfagents.messaging.query.QueryConsumer;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.Dataset;
import net.fortytwo.rdfagents.model.RDFAgent;
import org.openrdf.model.Value;

public class QueryConsumerImpl
extends QueryConsumer<Value, Dataset> {
    public QueryConsumerImpl(RDFAgent agent) {
        super(agent);
        if (!(agent instanceof RDFAgentImpl)) {
            throw new IllegalArgumentException("expected RDFAgent implementation " + RDFAgentImpl.class.getName() + ", found " + agent.getClass().getName());
        }
    }

    public String submit(Value query, AgentId remoteParticipant, ConsumerCallback<Dataset> callback) throws LocalFailure {
        try {
            RDFJadeAgent.Task t = ((RDFAgentImpl)this.agent).submitQuery(query, remoteParticipant, callback);
            ((RDFAgentImpl)this.agent).putObject(t);
            return t.getConversationId();
        }
        catch (StaleProxyException e) {
            throw new LocalFailure((Throwable)e);
        }
    }

    public void cancel(String conversationId, AgentId remoteParticipant, CancellationCallback callback) throws LocalFailure {
        try {
            RDFJadeAgent.Task t = ((RDFAgentImpl)this.agent).cancelQuery(conversationId, remoteParticipant, callback);
            ((RDFAgentImpl)this.agent).putObject(t);
        }
        catch (StaleProxyException e) {
            throw new LocalFailure((Throwable)e);
        }
    }
}

