/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.rdfagents.jade;

import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import java.util.HashSet;
import net.fortytwo.rdfagents.RDFAgentsTestCase;
import net.fortytwo.rdfagents.data.RecursiveDescribeQuery;
import net.fortytwo.rdfagents.model.AgentId;
import net.fortytwo.rdfagents.model.ErrorExplanation;
import net.fortytwo.rdfagents.model.RDFContentLanguage;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;

public class MessageFactoryTest
extends RDFAgentsTestCase {
    public void testPoseQuery() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        this.assertIsQuery(query);
        MessageFactoryTest.assertEquals((String)"((any ?dataset (describes ?dataset (resource :uri http://example.org/resourceX))))", (String)query.getContent());
        Value subject = this.messageFactory.extractDescribeQuery(query);
        MessageFactoryTest.assertTrue((boolean)(subject instanceof URI));
        MessageFactoryTest.assertEquals((String)"http://example.org/resourceX", (String)subject.stringValue());
        MessageFactoryTest.assertNull((Object)query.getUserDefinedParameter("X-rdfagents-accept"));
        query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.plainLiteralX, new RDFContentLanguage[0]);
        this.assertIsQuery(query);
        MessageFactoryTest.assertEquals((String)"((any ?dataset (describes ?dataset (literal :label \"Don't panic.\"))))", (String)query.getContent());
        subject = this.messageFactory.extractDescribeQuery(query);
        MessageFactoryTest.assertTrue((boolean)(subject instanceof Literal));
        MessageFactoryTest.assertEquals((String)"Don't panic.", (String)((Literal)subject).getLabel());
        MessageFactoryTest.assertNull((Object)((Literal)subject).getLanguage());
        MessageFactoryTest.assertNull((Object)((Literal)subject).getDatatype());
        MessageFactoryTest.assertNull((Object)query.getUserDefinedParameter("X-rdfagents-accept"));
        query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.typedLiteralX, new RDFContentLanguage[0]);
        this.assertIsQuery(query);
        MessageFactoryTest.assertEquals((String)"((any ?dataset (describes ?dataset (literal :label \"Don't panic.\" :datatype (resource :uri http://www.w3.org/2001/XMLSchema#string)))))", (String)query.getContent());
        subject = this.messageFactory.extractDescribeQuery(query);
        MessageFactoryTest.assertTrue((boolean)(subject instanceof Literal));
        MessageFactoryTest.assertEquals((String)"Don't panic.", (String)((Literal)subject).getLabel());
        MessageFactoryTest.assertNull((Object)((Literal)subject).getLanguage());
        MessageFactoryTest.assertEquals((Object)XMLSchema.STRING, (Object)((Literal)subject).getDatatype());
        MessageFactoryTest.assertNull((Object)query.getUserDefinedParameter("X-rdfagents-accept"));
        query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.languageLiteralX, new RDFContentLanguage[0]);
        this.assertIsQuery(query);
        MessageFactoryTest.assertEquals((String)"((any ?dataset (describes ?dataset (literal :label \"Don't panic.\" :language en))))", (String)query.getContent());
        subject = this.messageFactory.extractDescribeQuery(query);
        MessageFactoryTest.assertTrue((boolean)(subject instanceof Literal));
        MessageFactoryTest.assertEquals((String)"Don't panic.", (String)((Literal)subject).getLabel());
        MessageFactoryTest.assertEquals((String)"en", (String)((Literal)subject).getLanguage());
        MessageFactoryTest.assertNull((Object)((Literal)subject).getDatatype());
        MessageFactoryTest.assertNull((Object)query.getUserDefinedParameter("X-rdfagents-accept"));
        query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS});
        MessageFactoryTest.assertEquals((String)"rdf-nquads", (String)query.getUserDefinedParameter("X-rdfagents-accept"));
        query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS, RDFContentLanguage.RDF_TRIG});
        MessageFactoryTest.assertEquals((String)"rdf-nquads; rdf-trig", (String)query.getUserDefinedParameter("X-rdfagents-accept"));
    }

    public void testRefuseToAnswerQuery() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ErrorExplanation ex = new ErrorExplanation(ErrorExplanation.Type.Unavailable, "I prefer not to.");
        ACLMessage r = this.messageFactory.refuseToAnswerQuery(this.receiver, this.sender, query, ex);
        this.assertIsReply(r, query);
        MessageFactoryTest.assertEquals((int)14, (int)r.getPerformative());
        this.assertHasExplanation(r, "((unavailable \"I prefer not to.\"))");
        ErrorExplanation exp = this.messageFactory.extractErrorExplanation(r);
        MessageFactoryTest.assertEquals((Object)ErrorExplanation.Type.Unavailable, (Object)exp.getType());
        MessageFactoryTest.assertEquals((String)"I prefer not to.", (String)exp.getMessage());
    }

    public void testAgreeToAnswerQuery() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage r = this.messageFactory.agreeToAnswerQuery(this.receiver, this.sender, query);
        System.out.println(r);
        this.assertIsReply(r, query);
        MessageFactoryTest.assertEquals((int)1, (int)r.getPerformative());
        MessageFactoryTest.assertNull((Object)r.getContent());
    }

    public void testInformOfQueryResult() throws Exception {
        RecursiveDescribeQuery q = new RecursiveDescribeQuery((Value)ARTHUR, this.sail);
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)ARTHUR, new RDFContentLanguage[0]);
        ACLMessage result = this.messageFactory.informOfQueryResult(this.receiver, this.sender, query, q.evaluate(), RDFContentLanguage.RDF_TRIG);
        this.assertIsReply(result, query);
        MessageFactoryTest.assertEquals((int)9, (int)result.getPerformative());
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)result.getProtocol());
        this.assertHasRDFContent(result);
        MessageFactoryTest.assertEquals((String)"rdf-trig", (String)result.getLanguage());
        query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)ARTHUR, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS});
        result = this.messageFactory.informOfQueryResult(this.receiver, this.sender, query, q.evaluate(), RDFContentLanguage.RDF_TRIG);
        this.assertIsReply(result, query);
        MessageFactoryTest.assertEquals((int)9, (int)result.getPerformative());
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)result.getProtocol());
        this.assertHasRDFContent(result);
        MessageFactoryTest.assertEquals((String)"rdf-nquads", (String)result.getLanguage());
    }

    public void testFailToInformOfQueryResult() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)ARTHUR, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS});
        ErrorExplanation ex = new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "N-Quads format is not supported.");
        ACLMessage fail = this.messageFactory.failToInformOfQueryResult(this.receiver, this.sender, query, ex);
        this.assertIsReply(fail, query);
        MessageFactoryTest.assertEquals((int)6, (int)fail.getPerformative());
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)fail.getProtocol());
        this.assertHasExplanation(fail, "((not-implemented \"N-Quads format is not supported.\"))");
        ErrorExplanation exp = this.messageFactory.extractErrorExplanation(fail);
        MessageFactoryTest.assertEquals((Object)ErrorExplanation.Type.NotImplemented, (Object)exp.getType());
        MessageFactoryTest.assertEquals((String)"N-Quads format is not supported.", (String)exp.getMessage());
    }

    public void testRequestQueryCancellation() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage c = this.messageFactory.requestQueryCancellation(this.sender, this.receiver, query.getConversationId());
        this.assertIsCancellationRequest(c, query);
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)c.getProtocol());
    }

    public void testConfirmQueryCancellation() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage c = this.messageFactory.requestQueryCancellation(this.sender, this.receiver, query.getConversationId());
        ACLMessage confirm = this.messageFactory.confirmQueryCancellation(this.receiver, this.sender, c);
        this.assertIsReply(confirm, c);
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)confirm.getProtocol());
        MessageFactoryTest.assertEquals((int)4, (int)confirm.getPerformative());
    }

    public void testFailToCancelQuery() throws Exception {
        ACLMessage query = this.messageFactory.poseQuery(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage c = this.messageFactory.requestQueryCancellation(this.sender, this.receiver, query.getConversationId());
        ErrorExplanation ex = new ErrorExplanation(ErrorExplanation.Type.InteractionExplired, "I don't remember you.");
        ACLMessage fail = this.messageFactory.failToCancelQuery(this.receiver, this.sender, c, ex);
        this.assertIsReply(fail, c);
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)fail.getProtocol());
        MessageFactoryTest.assertEquals((int)6, (int)fail.getPerformative());
        this.assertHasExplanation(fail, "((interaction-expired \"I don't remember you.\"))");
        ErrorExplanation exp = this.messageFactory.extractErrorExplanation(fail);
        MessageFactoryTest.assertEquals((Object)ErrorExplanation.Type.InteractionExplired, (Object)exp.getType());
        MessageFactoryTest.assertEquals((String)"I don't remember you.", (String)exp.getMessage());
    }

    public void testRequestSubscription() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        this.assertIsSubscriptionRequest(request);
        MessageFactoryTest.assertEquals((String)"((any ?dataset (describes ?dataset (resource :uri http://example.org/resourceX))))", (String)request.getContent());
        Value subject = this.messageFactory.extractDescribeQuery(request);
        MessageFactoryTest.assertTrue((boolean)(subject instanceof URI));
        MessageFactoryTest.assertEquals((String)"http://example.org/resourceX", (String)subject.stringValue());
        MessageFactoryTest.assertNull((Object)request.getUserDefinedParameter("X-rdfagents-accept"));
        request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS});
        MessageFactoryTest.assertEquals((String)"rdf-nquads", (String)request.getUserDefinedParameter("X-rdfagents-accept"));
        request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS, RDFContentLanguage.RDF_TRIG});
        MessageFactoryTest.assertEquals((String)"rdf-nquads; rdf-trig", (String)request.getUserDefinedParameter("X-rdfagents-accept"));
    }

    public void testRefuseSubscriptionRequest() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ErrorExplanation ex = new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "Subscriptions are not supported.");
        ACLMessage r = this.messageFactory.refuseSubscriptionRequest(this.receiver, this.sender, request, ex);
        System.out.println(r);
        this.assertIsReply(r, request);
        MessageFactoryTest.assertEquals((int)14, (int)r.getPerformative());
        this.assertHasExplanation(r, "((not-implemented \"Subscriptions are not supported.\"))");
        ErrorExplanation exp = this.messageFactory.extractErrorExplanation(r);
        MessageFactoryTest.assertEquals((Object)ErrorExplanation.Type.NotImplemented, (Object)exp.getType());
        MessageFactoryTest.assertEquals((String)"Subscriptions are not supported.", (String)exp.getMessage());
    }

    public void testAgreeToSubscriptionRequest() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage r = this.messageFactory.agreeToSubcriptionRequest(this.receiver, this.sender, request);
        System.out.println(r);
        this.assertIsReply(r, request);
        MessageFactoryTest.assertEquals((int)1, (int)r.getPerformative());
        MessageFactoryTest.assertNull((Object)r.getContent());
    }

    public void testInformOfSubscriptionUpdate() throws Exception {
        RecursiveDescribeQuery q = new RecursiveDescribeQuery((Value)ARTHUR, this.sail);
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)ARTHUR, new RDFContentLanguage[0]);
        ACLMessage result = this.messageFactory.informOfSubscriptionUpdate(this.receiver, this.sender, request, q.evaluate(), RDFContentLanguage.RDF_TRIG);
        this.assertIsReply(result, request);
        MessageFactoryTest.assertEquals((int)9, (int)result.getPerformative());
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)result.getProtocol());
        this.assertHasRDFContent(result);
        MessageFactoryTest.assertEquals((String)"rdf-trig", (String)result.getLanguage());
        request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)ARTHUR, new RDFContentLanguage[]{RDFContentLanguage.RDF_NQUADS});
        result = this.messageFactory.informOfSubscriptionUpdate(this.receiver, this.sender, request, q.evaluate(), RDFContentLanguage.RDF_TRIG);
        this.assertIsReply(result, request);
        MessageFactoryTest.assertEquals((int)9, (int)result.getPerformative());
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)result.getProtocol());
        this.assertHasRDFContent(result);
        MessageFactoryTest.assertEquals((String)"rdf-nquads", (String)result.getLanguage());
    }

    public void testFailToInformOfSubscriptionUpdate() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ErrorExplanation ex = new ErrorExplanation(ErrorExplanation.Type.NotImplemented, "N-Quads format is not supported.");
        ACLMessage fail = this.messageFactory.failToInformOfSubscriptionUpdate(this.receiver, this.sender, request, ex);
        this.assertIsReply(fail, request);
        MessageFactoryTest.assertEquals((int)6, (int)fail.getPerformative());
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)fail.getProtocol());
        this.assertHasExplanation(fail, "((not-implemented \"N-Quads format is not supported.\"))");
        ErrorExplanation exp = this.messageFactory.extractErrorExplanation(fail);
        MessageFactoryTest.assertEquals((Object)ErrorExplanation.Type.NotImplemented, (Object)exp.getType());
        MessageFactoryTest.assertEquals((String)"N-Quads format is not supported.", (String)exp.getMessage());
    }

    public void testRequestSubscriptionCancellation() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage c = this.messageFactory.requestSubscriptionCancellation(this.sender, this.receiver, request.getConversationId());
        this.assertIsCancellationRequest(c, request);
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)c.getProtocol());
    }

    public void testConfirmSubscriptionCancellation() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage c = this.messageFactory.requestSubscriptionCancellation(this.sender, this.receiver, request.getConversationId());
        ACLMessage confirm = this.messageFactory.confirmSubscriptionCancellation(this.receiver, this.sender, c);
        this.assertIsReply(confirm, c);
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)confirm.getProtocol());
        MessageFactoryTest.assertEquals((int)4, (int)confirm.getPerformative());
    }

    public void testFailToCancelSubscription() throws Exception {
        ACLMessage request = this.messageFactory.requestSubscription(this.sender, this.receiver, (Value)this.resourceX, new RDFContentLanguage[0]);
        ACLMessage c = this.messageFactory.requestSubscriptionCancellation(this.sender, this.receiver, request.getConversationId());
        ErrorExplanation ex = new ErrorExplanation(ErrorExplanation.Type.InteractionExplired, "I don't remember you.");
        ACLMessage fail = this.messageFactory.failToCancelSubscription(this.receiver, this.sender, c, ex);
        this.assertIsReply(fail, c);
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)fail.getProtocol());
        MessageFactoryTest.assertEquals((int)6, (int)fail.getPerformative());
        this.assertHasExplanation(fail, "((interaction-expired \"I don't remember you.\"))");
        ErrorExplanation exp = this.messageFactory.extractErrorExplanation(fail);
        MessageFactoryTest.assertEquals((Object)ErrorExplanation.Type.InteractionExplired, (Object)exp.getType());
        MessageFactoryTest.assertEquals((String)"I don't remember you.", (String)exp.getMessage());
    }

    private void assertFromAndTo(ACLMessage message, AgentId sender, AgentId receiver) {
        this.matchAID(sender, message.getSender());
        int c = 0;
        Iterator iter = message.getAllIntendedReceiver();
        while (iter.hasNext()) {
            ++c;
            iter.next();
        }
        MessageFactoryTest.assertEquals((int)1, (int)c);
        this.matchAID(receiver, (AID)message.getAllIntendedReceiver().next());
    }

    private void assertIsQuery(ACLMessage message) {
        MessageFactoryTest.assertTrue((message.getConversationId().length() > 0 ? 1 : 0) != 0);
        MessageFactoryTest.assertEquals((String)"fipa-query", (String)message.getProtocol());
        this.assertHasOntologyContent(message);
        MessageFactoryTest.assertEquals((int)13, (int)message.getPerformative());
        this.assertFromAndTo(message, this.sender, this.receiver);
    }

    private void assertIsSubscriptionRequest(ACLMessage message) {
        MessageFactoryTest.assertTrue((message.getConversationId().length() > 0 ? 1 : 0) != 0);
        MessageFactoryTest.assertEquals((String)"fipa-subscribe", (String)message.getProtocol());
        this.assertHasOntologyContent(message);
        MessageFactoryTest.assertEquals((int)19, (int)message.getPerformative());
        this.assertFromAndTo(message, this.sender, this.receiver);
    }

    private void assertHasOntologyContent(ACLMessage message) {
        MessageFactoryTest.assertEquals((String)"fipa-sl2", (String)message.getLanguage());
        MessageFactoryTest.assertEquals((String)"rdfagents", (String)message.getOntology());
    }

    private void assertHasRDFContent(ACLMessage message) {
        RDFContentLanguage language = RDFContentLanguage.getByName((String)message.getLanguage());
        MessageFactoryTest.assertNotNull((Object)language);
        MessageFactoryTest.assertNull((Object)message.getOntology());
    }

    private void assertHasExplanation(ACLMessage message, String ex) {
        this.assertHasOntologyContent(message);
        MessageFactoryTest.assertEquals((String)ex, (String)message.getContent());
    }

    private void assertIsReply(ACLMessage message, ACLMessage replyTo) {
        this.assertFromAndTo(replyTo, this.sender, this.receiver);
        this.assertFromAndTo(message, this.receiver, this.sender);
        MessageFactoryTest.assertTrue((message.getConversationId().length() > 0 ? 1 : 0) != 0);
        MessageFactoryTest.assertEquals((String)replyTo.getConversationId(), (String)message.getConversationId());
    }

    private void assertIsCancellationRequest(ACLMessage message, ACLMessage originalRequest) {
        this.assertFromAndTo(message, this.sender, this.receiver);
        MessageFactoryTest.assertEquals((int)2, (int)message.getPerformative());
        MessageFactoryTest.assertEquals((String)originalRequest.getProtocol(), (String)message.getProtocol());
        MessageFactoryTest.assertEquals((String)originalRequest.getConversationId(), (String)message.getConversationId());
    }

    private void matchAID(AgentId expected, AID actual) {
        MessageFactoryTest.assertEquals((String)expected.getName().toString(), (String)actual.getName());
        HashSet<String> expectedAddresses = new HashSet<String>();
        for (URI uRI : expected.getTransportAddresses()) {
            expectedAddresses.add(uRI.toString());
        }
        MessageFactoryTest.assertEquals((int)expectedAddresses.size(), (int)actual.getAddressesArray().length);
        for (String string : actual.getAddressesArray()) {
            MessageFactoryTest.assertTrue((boolean)expectedAddresses.contains(string));
        }
    }
}

