/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.examples;

import java.net.InetSocketAddress;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.IAgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.AbstractAgentConnectionCallback;
import net.formicary.remoterun.embed.callback.AbstractTextOutputCallback;
import net.formicary.remoterun.embed.callback.AgentConnectionCallback;
import net.formicary.remoterun.embed.callback.TextOutputCallback;
import net.formicary.remoterun.embed.request.AgentRequest;
import net.formicary.remoterun.embed.request.MessageHelper;
import net.formicary.remoterun.embed.request.TextOutputRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRemoteRunMaster
extends AbstractAgentConnectionCallback {
    private static final Logger log = LoggerFactory.getLogger(SimpleRemoteRunMaster.class);

    public static void main(String[] args) {
        new SimpleRemoteRunMaster().run();
    }

    private void run() {
        RemoteRunMaster master = new RemoteRunMaster((AgentConnectionCallback)this);
        master.bind(new InetSocketAddress(1081));
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        for (IAgentConnection connection : master.getConnectedClients()) {
            connection.write(RemoteRun.MasterToAgent.newBuilder().setMessageType(RemoteRun.MasterToAgent.MessageType.RUN_COMMAND).setRequestId(RemoteRunMaster.getNextRequestId()).setRunCommand(RemoteRun.MasterToAgent.RunCommand.newBuilder().setCmd("echo").addArgs("Thanks for connecting!")).build());
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info("Shutting down SimpleRemoteRunMaster");
        master.shutdown();
    }

    public void agentConnected(IAgentConnection agentConnection) {
        agentConnection.request((AgentRequest)new TextOutputRequest(MessageHelper.runCommand((String)"echo", (String[])new String[]{"Hello World!"}), (TextOutputCallback)new AbstractTextOutputCallback(){}));
    }
}

