/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.examples;

import java.io.Closeable;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.formicary.remoterun.common.FileReceiver;
import net.formicary.remoterun.common.IoUtils;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.IAgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.AgentConnectionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServer
implements AgentConnectionCallback {
    private static final String DEMO_REQUEST_PATH = "/var/tmp/test";
    private static final Logger log = LoggerFactory.getLogger(FileServer.class);
    private static final int PORT = 1222;
    private long uploadId;
    private FileReceiver receiver;

    public static void main(String[] args) {
        new FileServer().run();
    }

    private void run() {
        new RemoteRunMaster((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), (AgentConnectionCallback)this).bind(new InetSocketAddress(1222));
    }

    public void agentConnected(IAgentConnection agentConnection) {
        this.uploadId = agentConnection.upload(Paths.get(DEMO_REQUEST_PATH, new String[0]), "demopath", null);
    }

    public void messageReceived(IAgentConnection agentConnection, RemoteRun.AgentToMaster message) throws Exception {
        if (message.getMessageType() == RemoteRun.AgentToMaster.MessageType.RECEIVED_DATA && message.getRequestId() == this.uploadId) {
            log.info("Completed receipt of system.log, re-downloading...");
            this.receiver = new FileReceiver(Files.createTempDirectory("received_", new FileAttribute[0]));
            new Thread((Runnable)this.receiver).start();
            agentConnection.write(RemoteRun.MasterToAgent.newBuilder().setRequestId(RemoteRunMaster.getNextRequestId()).setMessageType(RemoteRun.MasterToAgent.MessageType.REQUEST_DATA).setPath("/var/tmp/system.log").build());
        } else if (message.getMessageType() == RemoteRun.AgentToMaster.MessageType.REQUESTED_DATA) {
            if (message.hasExitCode()) {
                IoUtils.closeQuietly((Closeable)this.receiver.getPipedOutputStream());
                this.receiver.waitUntilFinishedUninterruptably();
                if (this.receiver.success()) {
                    log.info("Written data to {}", (Object)this.receiver.getRoot());
                } else {
                    log.warn("Failed to write " + this.receiver.getRoot() + ": " + this.receiver.getFailureMessage(), this.receiver.getFailure());
                }
            } else {
                message.getFragment().writeTo((OutputStream)this.receiver.getPipedOutputStream());
            }
        }
    }

    public void agentDisconnected(IAgentConnection agentConnection) {
    }
}

