/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.examples;

import com.google.protobuf.ByteString;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.formicary.remoterun.common.RemoteRunException;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.AgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.AgentConnectionCallback;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements AgentConnectionCallback {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private RemoteRunMaster remoteRunMaster;

    public static void main(String[] args) {
        new Server().run();
    }

    public void run() {
        this.remoteRunMaster = new RemoteRunMaster((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), (AgentConnectionCallback)this);
        InetSocketAddress bindAddress = new InetSocketAddress(1081);
        this.remoteRunMaster.bind(bindAddress);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, CharsetUtil.UTF_8));
            while ((line = reader.readLine()) != null) {
                try {
                    if (line.startsWith("l")) {
                        this.listClientConnections();
                        continue;
                    }
                    if (line.startsWith("r")) {
                        this.runCommand(line);
                        continue;
                    }
                    if (line.startsWith("i")) {
                        this.sendInput(line);
                        continue;
                    }
                    if (line.startsWith("c")) {
                        this.closeInput(line);
                        continue;
                    }
                    log.warn("Unhandled command: " + line);
                }
                catch (Exception e) {
                    log.error("Failed to process command: " + line, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new RemoteRunException("Failed whilst processing user input, shutting down", (Throwable)e);
        }
        finally {
            this.remoteRunMaster.shutdown();
        }
    }

    private void listClientConnections() {
        Set agentConnections = this.remoteRunMaster.getAgentConnections();
        int count = 0;
        for (AgentConnection agentConnection : agentConnections) {
            log.info(++count + ": " + agentConnection.getConnectionState().name() + " " + agentConnection.getChannel().getRemoteAddress());
        }
        log.info("Finished listing " + agentConnections.size() + " agent connections");
    }

    private void runCommand(String line) {
        StrTokenizer tokenizer = new StrTokenizer(line, ' ', '\"');
        List tokens = tokenizer.getTokenList();
        tokens.remove(0);
        String command = (String)tokens.remove(0);
        Collection connectedClients = this.remoteRunMaster.getConnectedClients();
        if (connectedClients.isEmpty()) {
            log.error("Unable to send command: no agent connections");
        } else {
            AgentConnection connection = (AgentConnection)connectedClients.iterator().next();
            RemoteRun.MasterToAgent.Builder builder = RemoteRun.MasterToAgent.newBuilder().setMessageType(RemoteRun.MasterToAgent.MessageType.RUN_COMMAND).setRequestId(RemoteRunMaster.getNextRequestId());
            builder.getRunCommandBuilder().setCmd(command).addAllArgs((Iterable)tokens);
            connection.getChannel().write((Object)builder.build());
        }
    }

    private void sendInput(String line) {
        StrTokenizer tokenizer = new StrTokenizer(line, ' ', '\"');
        List tokens = tokenizer.getTokenList();
        tokens.remove(0);
        long id = Long.parseLong((String)tokens.remove(0));
        String input = StringUtils.join((Collection)tokens, (char)' ').replaceAll("\\\\n", "\n");
        Collection connectedClients = this.remoteRunMaster.getConnectedClients();
        if (connectedClients.isEmpty()) {
            log.error("Unable to send command: no agent connections");
        } else {
            AgentConnection connection = (AgentConnection)connectedClients.iterator().next();
            RemoteRun.MasterToAgent.Builder builder = RemoteRun.MasterToAgent.newBuilder().setMessageType(RemoteRun.MasterToAgent.MessageType.STDIN_FRAGMENT).setRequestId(id).setFragment(ByteString.copyFromUtf8((String)input));
            connection.getChannel().write((Object)builder.build());
        }
    }

    private void closeInput(String line) {
        StrTokenizer tokenizer = new StrTokenizer(line, ' ', '\"');
        List tokens = tokenizer.getTokenList();
        tokens.remove(0);
        long id = Long.parseLong((String)tokens.remove(0));
        Collection connectedClients = this.remoteRunMaster.getConnectedClients();
        if (connectedClients.isEmpty()) {
            log.error("Unable to send command: no agent connections");
        } else {
            AgentConnection connection = (AgentConnection)connectedClients.iterator().next();
            RemoteRun.MasterToAgent.Builder builder = RemoteRun.MasterToAgent.newBuilder().setMessageType(RemoteRun.MasterToAgent.MessageType.CLOSE_STDIN).setRequestId(id);
            connection.getChannel().write((Object)builder.build());
        }
    }

    public void agentConnected(AgentConnection agentConnection) {
    }

    public void messageReceived(AgentConnection agentConnection, RemoteRun.AgentToMaster message) {
    }

    public void agentDisconnected(AgentConnection agentConnection) {
    }
}

