/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.examples;

import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.formicary.remoterun.embed.AgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.AbstractAgentConnectionCallback;
import net.formicary.remoterun.embed.callback.AgentConnectionCallback;
import net.formicary.remoterun.embed.callback.FileDownloadCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadingMaster {
    private static final String REMOTE_SOURCE_FILE = "/var/tmp/demo.file";
    private static final Logger log = LoggerFactory.getLogger(DownloadingMaster.class);

    public static void main(String[] args) {
        new RemoteRunMaster((AgentConnectionCallback)new AbstractAgentConnectionCallback(){

            public void agentConnected(AgentConnection agentConnection) {
                DownloadingMaster.downloadFrom(agentConnection);
            }
        }).bind(new InetSocketAddress(1081));
    }

    private static void downloadFrom(AgentConnection agentConnection) {
        try {
            final Path tempDirectory = Files.createTempDirectory("RemoteRunExample_DownloadingMaster", new FileAttribute[0]);
            agentConnection.download(REMOTE_SOURCE_FILE, tempDirectory, new FileDownloadCallback(){

                public void onExit(int exitCode, String exitReason) {
                    log.info("File download to {} complete, exitCode={}, exitReason={}", new Object[]{tempDirectory, exitCode, exitReason});
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to download from agent " + agentConnection, (Throwable)e);
            agentConnection.shutdown();
        }
    }
}

