/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.examples;

import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.formicary.remoterun.embed.AgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.AbstractAgentConnectionCallback;
import net.formicary.remoterun.embed.callback.AgentConnectionCallback;
import net.formicary.remoterun.embed.callback.UploadCompleteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadingMaster {
    private static final String LOCAL_SOURCE_FILE = "README.md";
    private static final Logger log = LoggerFactory.getLogger(UploadingMaster.class);

    public static void main(String[] args) {
        new RemoteRunMaster((AgentConnectionCallback)new AbstractAgentConnectionCallback(){

            public void agentConnected(AgentConnection agentConnection) {
                UploadingMaster.uploadTo(agentConnection);
            }
        }).bind(new InetSocketAddress(1081));
    }

    private static void uploadTo(AgentConnection agentConnection) {
        try {
            final Path tempDirectory = Files.createTempDirectory("RemoteRunExample_UploadingMaster", new FileAttribute[0]);
            agentConnection.upload(Paths.get(LOCAL_SOURCE_FILE, new String[0]), tempDirectory.toString(), new UploadCompleteCallback(){

                public void uploadComplete(AgentConnection agent, long requestId, String targetPath, boolean success) {
                    log.info("File upload of {} to {} complete, success={}", new Object[]{UploadingMaster.LOCAL_SOURCE_FILE, tempDirectory, success});
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to upload to agent " + agentConnection, (Throwable)e);
            agentConnection.shutdown();
        }
    }
}

