/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.embed;

import com.google.protobuf.ByteString;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.formicary.remoterun.common.FileStreamer;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.ConnectionState;
import net.formicary.remoterun.embed.IAgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.FileDownloadCallback;
import net.formicary.remoterun.embed.callback.UploadCompleteCallback;
import net.formicary.remoterun.embed.request.AgentRequest;
import net.formicary.remoterun.embed.request.FileDownloadRequest;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConnection
implements IAgentConnection {
    private static final Logger log = LoggerFactory.getLogger(AgentConnection.class);
    private final ReentrantLock writeLock = new ReentrantLock(true);
    private final Map<Long, AgentRequest> requestHandlers = new ConcurrentHashMap<Long, AgentRequest>();
    private final SocketAddress remoteAddress;
    private ChannelFuture lastWriteFuture;
    private Channel channel;
    private ConnectionState connectionState;
    private RemoteRun.AgentToMaster.AgentInfo agentInfo;

    public AgentConnection(Channel channel) {
        this.channel = channel;
        this.remoteAddress = channel.getRemoteAddress();
        this.connectionState = ConnectionState.HANDSHAKING;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public RemoteRun.AgentToMaster.AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    @Override
    public void setAgentInfo(RemoteRun.AgentToMaster.AgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    @Override
    public void shutdown() {
        this.channel.close();
    }

    @Override
    public long upload(Path localSourcePath, final String remoteTargetDirectory, final UploadCompleteCallback callback) {
        final long requestId = RemoteRunMaster.getNextRequestId();
        this.write(RemoteRun.MasterToAgent.newBuilder().setRequestId(requestId).setMessageType(RemoteRun.MasterToAgent.MessageType.SEND_DATA_NOTIFICATION).setPath(remoteTargetDirectory).build());
        new FileStreamer(localSourcePath, new FileStreamer.FileStreamerCallback(){

            public void writeDataChunk(byte[] data, int offset, int length) {
                AgentConnection.this.write(RemoteRun.MasterToAgent.newBuilder().setRequestId(requestId).setMessageType(RemoteRun.MasterToAgent.MessageType.SEND_DATA_FRAGMENT).setFragment(ByteString.copyFrom((byte[])data, (int)offset, (int)length)).build());
            }

            public void finished(boolean success, String errorMessage, Throwable cause) {
                if (!success) {
                    log.error("Failed to send data to " + AgentConnection.this.getChannel().getRemoteAddress() + " - remoteTargetDirectory=" + remoteTargetDirectory, cause);
                }
                AgentConnection.this.write(RemoteRun.MasterToAgent.newBuilder().setRequestId(requestId).setMessageType(RemoteRun.MasterToAgent.MessageType.SEND_DATA_FRAGMENT).setDataSuccess(success).build());
                if (callback != null) {
                    callback.uploadComplete(AgentConnection.this, requestId, remoteTargetDirectory, success);
                }
            }
        }).run();
        return requestId;
    }

    @Override
    public long download(String remoteSourcePath, Path localTargetDirectory, FileDownloadCallback callback) {
        return this.request(new FileDownloadRequest(remoteSourcePath, localTargetDirectory, callback));
    }

    public String toString() {
        return "AgentConnection{channel=" + this.channel + ", connectionState=" + (Object)((Object)this.connectionState) + ", remoteAddress=" + this.remoteAddress + ", agentInfo=" + this.agentInfo + '}';
    }

    @Override
    public long request(AgentRequest message) {
        RemoteRun.MasterToAgent msg = message.getMessage();
        if (!msg.hasRequestId()) {
            throw new RuntimeException("Invalid message - requestId is not set: " + message);
        }
        this.requestHandlers.put(msg.getRequestId(), message);
        this.write(msg);
        return msg.getRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RemoteRun.MasterToAgent message) {
        this.writeLock.lock();
        try {
            if (this.lastWriteFuture != null) {
                try {
                    this.lastWriteFuture.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastWriteFuture = this.channel.write((Object)message);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void messageReceived(AgentConnection agent, RemoteRun.AgentToMaster message) {
        AgentRequest handler;
        if (message.hasRequestId() && (handler = this.requestHandlers.get(message.getRequestId())) != null) {
            handler.receivedMessage(agent, message);
        }
    }
}

