/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.embed.request;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import net.formicary.remoterun.common.FileReceiver;
import net.formicary.remoterun.common.IoUtils;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.AgentConnection;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.FileDownloadCallback;
import net.formicary.remoterun.embed.request.AgentRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadRequest
implements AgentRequest {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadRequest.class);
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final String remoteSource;
    private final Path localTargetRoot;
    private final FileDownloadCallback callback;
    private final RemoteRun.MasterToAgent message;
    private final FileReceiver receiver;
    private final Thread receiverThread;

    public FileDownloadRequest(String remoteSource, Path localTargetRoot, FileDownloadCallback callback) {
        this.remoteSource = remoteSource;
        this.localTargetRoot = localTargetRoot;
        this.callback = callback;
        this.message = RemoteRun.MasterToAgent.newBuilder().setMessageType(RemoteRun.MasterToAgent.MessageType.REQUEST_DATA).setPath(remoteSource).setRequestId(RemoteRunMaster.getNextRequestId()).build();
        this.receiver = new FileReceiver(localTargetRoot);
        this.receiverThread = new Thread((Runnable)this.receiver, "FileReceiver:" + localTargetRoot);
        this.receiverThread.start();
    }

    @Override
    public RemoteRun.MasterToAgent getMessage() {
        return this.message;
    }

    @Override
    public CountDownLatch getCompletionLatch() {
        return this.completionLatch;
    }

    public void close() {
        IoUtils.closeQuietly((Closeable)this.receiver);
        this.receiverThread.interrupt();
    }

    @Override
    public void receivedMessage(AgentConnection agent, RemoteRun.AgentToMaster message) {
        if (message.getMessageType() == RemoteRun.AgentToMaster.MessageType.REQUESTED_DATA) {
            if (message.hasFragment()) {
                try {
                    message.getFragment().writeTo((OutputStream)this.receiver.getPipedOutputStream());
                }
                catch (IOException e) {
                    log.error("Failed to receive data for " + this.remoteSource, (Throwable)e);
                    this.close();
                    this.callback.onExit(-1, "Failed streaming data internally: " + e.getMessage());
                }
            }
            if (message.hasExitCode()) {
                this.receiver.waitUntilFinishedUninterruptably();
                this.close();
                if (message.getExitCode() == 0) {
                    log.info("Successfully received {} to {}", (Object)this.remoteSource, (Object)this.localTargetRoot);
                } else {
                    log.info("Failed whilst receiving {} to {}: {}", new Object[]{this.remoteSource, this.localTargetRoot, message.getExitReason()});
                }
                this.callback.onExit(message.getExitCode(), message.getExitReason());
                this.close();
            }
        }
    }
}

